/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.semantics.Attribute;
import net.oneandone.mork.semantics.Compare;
import net.oneandone.sushi.util.IntArrayList;

public class Alternative
implements Compare {
    public final int production;
    public final int resultOfs;
    private final IntArrayList argsOfs;
    private final ArrayList<Attribute> argsCopy;

    public Alternative(Alternative orig) {
        this(orig.production, orig.resultOfs);
        this.addAll(orig.argsOfs, orig.argsCopy);
    }

    public Alternative(int production, int resultOfs) {
        this.production = production;
        this.resultOfs = resultOfs;
        this.argsOfs = new IntArrayList();
        this.argsCopy = new ArrayList();
    }

    public void add(int ofs, Attribute copy) {
        int i;
        int max = this.argsOfs.size();
        for (i = 0; i < max && ofs >= this.argsOfs.get(i); ++i) {
        }
        this.argsOfs.add(i, ofs);
        this.argsCopy.add(i, copy);
    }

    public void addAll(IntArrayList argsOfs, List<Attribute> argsCopy) {
        int max = argsOfs.size();
        for (int i = 0; i < max; ++i) {
            this.add(argsOfs.get(i), argsCopy.get(i));
        }
    }

    public int compare(Alternative ab) {
        if (this.production != ab.production) {
            throw new IllegalArgumentException();
        }
        if (this.resultOfs != -1 || ab.resultOfs != -1) {
            return 8;
        }
        if (this.argsOfs.size() == 0 && ab.argsOfs.size() == 0) {
            return 1;
        }
        if (this.argsOfs.size() == 0 || ab.argsOfs.size() == 0) {
            return 16;
        }
        if (Alternative.max(this.argsOfs) < Alternative.min(ab.argsOfs)) {
            return 2;
        }
        if (Alternative.min(this.argsOfs) > Alternative.max(ab.argsOfs)) {
            return 4;
        }
        if (this.argsOfs.size() != 1 || ab.argsOfs.size() != 1) {
            return 8;
        }
        if (this.argsOfs.get(0) != ab.argsOfs.get(0)) {
            throw new IllegalStateException();
        }
        return 1;
    }

    private static int min(IntArrayList ofs) {
        int result = Integer.MAX_VALUE;
        int max = ofs.size();
        for (int i = 0; i < max; ++i) {
            result = Math.min(result, ofs.get(i));
        }
        return result;
    }

    private static int max(IntArrayList ofs) {
        int result = Integer.MIN_VALUE;
        int max = ofs.size();
        for (int i = 0; i < max; ++i) {
            result = Math.max(result, ofs.get(i));
        }
        return result;
    }

    public int getArgCount() {
        return this.argsCopy.size();
    }

    public Attribute getArgAttribute(int i) {
        return this.argsCopy.get(i);
    }

    public int getArgOfs(int i) {
        return this.argsOfs.get(i);
    }

    public void addArgAttrs(List<Attribute> next) {
        int max = this.getArgCount();
        for (int i = 0; i < max; ++i) {
            Attribute attr = this.getArgAttribute(i);
            if (next.indexOf(attr) != -1) continue;
            next.add(attr);
        }
    }

    public boolean contains(int ofs, Attribute attr) {
        int max = this.argsOfs.size();
        for (int i = 0; i < max; ++i) {
            if (this.argsOfs.get(i) != ofs || this.getArgAttribute(i) != attr) continue;
            return true;
        }
        return false;
    }

    public String toRawString() {
        StringBuilder buf = new StringBuilder();
        buf.append("prod " + this.production + "$" + this.resultOfs);
        buf.append("\n\t");
        int max = this.argsOfs.size();
        int prevIdx = -1;
        for (int i = 0; i < max; ++i) {
            int idx = this.argsOfs.get(i);
            while (prevIdx < idx) {
                buf.append('\t');
                ++prevIdx;
            }
            buf.append(this.getArgAttribute(i).toString());
            buf.append('$');
            buf.append(idx);
            buf.append(' ');
        }
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("prod " + this.production + "$" + this.resultOfs);
        buf.append("  <==  (");
        int max = this.argsOfs.size();
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.getArgAttribute(i).toString());
            buf.append('$');
            buf.append(this.argsOfs.get(i));
        }
        buf.append(')');
        return buf.toString();
    }

    public int hashCode() {
        return this.production;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

