/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import java.util.List;
import net.oneandone.mork.misc.StringArrayList;
import net.oneandone.mork.semantics.Type;

public class Attribute {
    public final String name;
    public final int symbol;
    public final Type type;

    public Attribute(int symbol, String name, Type type) {
        this.name = name;
        this.symbol = symbol;
        this.type = type;
    }

    public Attribute(int symbol, String name) {
        this(symbol, name, new Type(Object.class));
    }

    public Attribute(Attribute orig) {
        this.name = orig.name;
        this.symbol = orig.symbol;
        this.type = orig.type;
    }

    public static Attribute find(List<Attribute> attrs, int symbol, String name) {
        int max = attrs.size();
        for (int i = 0; i < max; ++i) {
            Attribute attr = attrs.get(i);
            if (attr.symbol != symbol || !name.equals(attr.name)) continue;
            return attr;
        }
        return null;
    }

    public int hashCode() {
        return this.symbol;
    }

    public String toString() {
        return "symbol=" + this.symbol + ", name=" + this.name + ", " + this.type;
    }

    public String toString(StringArrayList symbolTable) {
        return symbolTable.get(this.symbol) + "." + this.name;
    }
}

