/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import net.oneandone.mork.misc.StringArrayList;
import net.oneandone.mork.semantics.Attribute;

public class AttributeOccurrence {
    public final Attribute attr;
    public final int ofs;

    public AttributeOccurrence(Attribute attr, int ofs) {
        this.attr = attr;
        this.ofs = ofs;
    }

    public String toString() {
        return this.attr.toString() + '[' + this.ofs + ']';
    }

    public String toString(StringArrayList symbolTable) {
        return symbolTable.getOrIndex(this.attr.symbol) + '[' + this.ofs + "]." + this.attr.hashCode();
    }

    public boolean matches(AttributeOccurrence ao) {
        return this.attr == ao.attr && (this.ofs == -1 && ao.ofs != -1 || this.ofs != -1 && ao.ofs == -1);
    }

    public boolean sameSymbolOccurrence(AttributeOccurrence ao) {
        return this.attr.symbol == ao.attr.symbol && this.ofs == ao.ofs;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttributeOccurrence) {
            AttributeOccurrence ao = (AttributeOccurrence)obj;
            return this.attr == ao.attr && this.ofs == ao.ofs;
        }
        return false;
    }

    public int hashCode() {
        return this.ofs;
    }
}

