/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import net.oneandone.mork.reflect.Function;
import net.oneandone.mork.scanner.Position;
import net.oneandone.mork.semantics.Node;
import net.oneandone.mork.semantics.SemanticError;

public class Attribution
implements Serializable {
    private final Function function;
    private final int resultOfs;
    private final int resultAttr;
    private final int[] argsOfs;
    private final int[] argsAttr;
    private final transient Object[] args;

    public Attribution(Function function, int resultOfs, int resultAttr, int[] argsOfs, int[] argsAttr) {
        this.function = function;
        this.resultOfs = resultOfs;
        this.resultAttr = resultAttr;
        this.argsOfs = argsOfs;
        this.argsAttr = argsAttr;
        this.args = new Object[argsOfs.length];
    }

    public Object newInstance() {
        return new Attribution(this.function, this.resultOfs, this.resultAttr, this.argsOfs, this.argsAttr);
    }

    public void eval(Node ctx, PrintWriter verbose) throws SemanticError {
        Object result;
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = ctx.get((int)this.argsOfs[i]).attrs[this.argsAttr[i]];
        }
        try {
            result = this.function.invoke(this.args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof Exception) {
                if (verbose != null) {
                    this.log("[FAILURE]", verbose);
                }
                Position pos = new Position();
                pos.set(ctx.position);
                throw new SemanticError(pos, (Exception)t);
            }
            throw new RuntimeException("illegal exception type: " + t);
        }
        ctx.get((int)this.resultOfs).attrs[this.resultAttr] = result;
        if (verbose != null) {
            this.log(result, verbose);
        }
    }

    private void log(Object result, PrintWriter verbose) {
        verbose.print("attribution: ");
        verbose.print(Attribution.shortName(result));
        verbose.print(" <- ");
        verbose.print(this.function.getName());
        verbose.print('(');
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                verbose.print(", ");
            }
            verbose.print(Attribution.shortName(this.args[i]));
        }
        verbose.println(")");
    }

    private static String shortName(Object obj) {
        if (obj == null) {
            return "null";
        }
        String clazz = obj.getClass().getName();
        int idx = clazz.lastIndexOf(46);
        clazz = clazz.substring(idx + 1);
        return clazz + "#" + Integer.toHexString(obj.hashCode());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.function.toString());
        buf.append(this.resultAttr);
        buf.append('$');
        buf.append(this.resultOfs);
        buf.append('(');
        for (int i = 0; i < this.argsOfs.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.argsAttr[i] + "$" + this.argsOfs[i]);
        }
        buf.append(')');
        return buf.toString();
    }
}

