/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.misc.StringArrayList;
import net.oneandone.mork.reflect.Function;
import net.oneandone.mork.semantics.AttributeOccurrence;

public class AttributionBuffer {
    public final int production;
    public Function function;
    public final AttributeOccurrence result;
    private final List<AttributeOccurrence> args;

    public AttributionBuffer(AttributionBuffer orig) {
        this(orig.production, orig.function, orig.result);
        this.addAll(orig.args);
    }

    public AttributionBuffer(int production, Function function, AttributeOccurrence result) {
        if (function == null) {
            throw new IllegalArgumentException();
        }
        this.production = production;
        this.function = function;
        this.result = result;
        this.args = new ArrayList<AttributeOccurrence>();
    }

    public void add(AttributeOccurrence attr) {
        this.args.add(attr);
    }

    public void addAll(List<AttributeOccurrence> args) {
        for (AttributeOccurrence arg : args) {
            this.add(arg);
        }
    }

    public int getArgCount() {
        return this.args.size();
    }

    public AttributeOccurrence getArg(int i) {
        return this.args.get(i);
    }

    public int hashCode() {
        return this.production;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("prod ");
        buf.append(this.production);
        buf.append(':');
        buf.append(this.result);
        buf.append("  <==  (");
        int max = this.args.size();
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.args.get(i).toString());
        }
        buf.append(')');
        if (this.function != null) {
            buf.append("  [");
            buf.append(this.function.toString());
            buf.append(']');
        }
        return buf.toString();
    }

    public void attrsToString(StringBuilder buffer, StringArrayList symbolTable) {
        buffer.append(this.function.getReturnType().getName());
        buffer.append(' ');
        buffer.append(this.result.toString(symbolTable));
        buffer.append(" = ");
        buffer.append(this.function.getName());
        buffer.append('(');
        int max = this.args.size();
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.function.getParameterTypes()[i].getName());
            buffer.append(' ');
            buffer.append(this.args.get(i).toString(symbolTable));
        }
        buffer.append(')');
    }
}

