/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import net.oneandone.mork.semantics.IllegalLiteral;

public class BuiltIn {
    public static final Object NULL = null;
    private static String text = null;
    private static int ofs;
    private static int len;

    public static char parseChar(String textInit) throws IllegalLiteral {
        text = textInit;
        ofs = 1;
        len = text.length();
        try {
            if (len > 2 && text.charAt(0) == '\'' && text.charAt(len - 1) == '\'') {
                char result = BuiltIn.charOrEscape();
                if (ofs + 1 == len) {
                    char c = result;
                    return c;
                }
            }
            throw new IllegalLiteral("illegal character literal: " + textInit);
        }
        finally {
            text = null;
        }
    }

    public static String parseString(String textInit) throws IllegalLiteral {
        try {
            text = textInit;
            len = text.length();
            ofs = 1;
            StringBuilder result = new StringBuilder();
            if (len >= 2 && text.charAt(0) == '\"' && text.charAt(len - 1) == '\"') {
                while (ofs + 1 < len) {
                    result.append(BuiltIn.charOrEscape());
                }
            } else {
                throw new IllegalLiteral("illegal string literal: " + textInit);
            }
            String string = result.toString();
            return string;
        }
        finally {
            text = null;
        }
    }

    private static char charOrEscape() throws IllegalLiteral {
        if (text.charAt(ofs) == '\\') {
            ++ofs;
            int result = BuiltIn.charEscape();
            if (result != -1) {
                return (char)result;
            }
            result = BuiltIn.unicodeEscape();
            if (result != -1) {
                return (char)result;
            }
            throw new IllegalLiteral("illegal literal");
        }
        return text.charAt(ofs++);
    }

    private static int unicodeEscape() {
        int start = ofs;
        while (ofs < len && text.charAt(ofs) == 'u') {
            ++ofs;
        }
        if (ofs == start || ofs + 4 > len) {
            return -1;
        }
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            int v = Character.digit(text.charAt(ofs + i), 16);
            if (v == -1) {
                return -1;
            }
            result = result * 16 + v;
        }
        ofs += 4;
        return result;
    }

    private static int charEscape() {
        if (ofs < len) {
            switch (text.charAt(ofs++)) {
                case 'b': {
                    return 8;
                }
                case 't': {
                    return 9;
                }
                case 'n': {
                    return 10;
                }
                case 'f': {
                    return 12;
                }
                case 'r': {
                    return 13;
                }
                case '\"': {
                    return 34;
                }
                case '\'': {
                    return 39;
                }
                case '\\': {
                    return 92;
                }
            }
            --ofs;
            return -1;
        }
        return -1;
    }
}

