/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.semantics.Attribute;
import net.oneandone.mork.semantics.AttributeOccurrence;
import net.oneandone.mork.semantics.Attribution;
import net.oneandone.mork.semantics.AttributionBuffer;

public class Layout {
    private final List<List<Attribute>> attrs = new ArrayList<List<Attribute>>();

    public int locate(Attribute attr) {
        if (attr.symbol < this.attrs.size()) {
            List<Attribute> lst = this.attrs.get(attr.symbol);
            int max = lst.size();
            for (int i = 0; i < max; ++i) {
                if (attr != lst.get(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public int getLocationCount(int symbol) {
        if (symbol < this.attrs.size()) {
            return this.attrs.get(symbol).size();
        }
        return 0;
    }

    public Attribution createAttribution(AttributionBuffer ab) {
        int resultLocation = this.locate(ab.result.attr);
        if (resultLocation == -1) {
            throw new RuntimeException("invalid semantics");
        }
        int[] argsLocation = new int[ab.getArgCount()];
        int[] argsOfs = new int[ab.getArgCount()];
        for (int i = 0; i < argsLocation.length; ++i) {
            AttributeOccurrence arg = ab.getArg(i);
            argsLocation[i] = this.locate(arg.attr);
            argsOfs[i] = arg.ofs;
            if (argsLocation[i] != -1) continue;
            throw new RuntimeException("invalid semantics");
        }
        return new Attribution(ab.function, ab.result.ofs, resultLocation, argsOfs, argsLocation);
    }

    public void add(Attribute attr) {
        if (this.locate(attr) == -1) {
            int symbol = attr.symbol;
            while (this.attrs.size() <= symbol) {
                this.attrs.add(new ArrayList());
            }
            List<Attribute> lst = this.attrs.get(symbol);
            lst.add(attr);
        }
    }

    public void add(AttributionBuffer ab) {
        this.add(ab.result.attr);
        int max = ab.getArgCount();
        for (int i = 0; i < max; ++i) {
            this.add(ab.getArg((int)i).attr);
        }
    }
}

