/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import java.io.PrintWriter;
import net.oneandone.mork.scanner.Position;
import net.oneandone.mork.semantics.Attribution;
import net.oneandone.mork.semantics.NodeFactory;
import net.oneandone.mork.semantics.SemanticError;
import net.oneandone.mork.semantics.Visits;

public class Node {
    private final NodeFactory pool;
    public final Position position;
    public final Node[] children;
    public final Object[] attrs;
    private final Visits visits;
    private int ofs;
    private static final Node[] NO_CHILDREN = new Node[0];
    private static final Object[] NO_ATTRIBUTES = new Object[0];

    public Node(NodeFactory pool, int children, int attributes, Visits visits) {
        this.pool = pool;
        this.children = children == 0 ? NO_CHILDREN : new Node[children];
        this.attrs = attributes == 0 ? NO_ATTRIBUTES : new Object[attributes];
        this.visits = visits;
        this.position = new Position();
    }

    public void init() {
        this.ofs = 0;
    }

    public String getText() {
        return "TODO";
    }

    public Node get(int ofs) {
        if (ofs == -1) {
            return this;
        }
        return this.children[ofs];
    }

    public void compute(PrintWriter log) throws SemanticError {
        if (log != null) {
            log.println("visit " + this.hashCode());
        }
        int max = this.visits.size();
        while (this.ofs < max) {
            Object visit;
            if ((visit = this.visits.get(this.ofs++)) instanceof Attribution) {
                ((Attribution)visit).eval(this, log);
                continue;
            }
            int next = Visits.getOfs(visit);
            if (next == -1) {
                return;
            }
            this.children[next].compute(log);
        }
        for (Node n : this.children) {
            n.pool.free(n);
        }
    }
}

