/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import net.oneandone.mork.parser.Parser;
import net.oneandone.mork.scanner.Position;
import net.oneandone.mork.scanner.Scanner;
import net.oneandone.mork.semantics.Node;
import net.oneandone.mork.semantics.Visits;

public class NodeFactory {
    private final Node[] pool;
    private int used;
    private final int children;
    private final int[] internalAttrs;
    private final Visits visits;
    private static final Visits NO_VISITS = new Visits(new Object[0]);
    public static final int NONE = 0;
    public static final int TEXT = 1;
    public static final int LINE = 2;
    public static final int COLUMN = 3;
    public static final int OFFSET = 4;
    public static final int ENVIRONMENT = 5;

    public NodeFactory(int size, int[] internalAttrs) {
        this(size, 0, internalAttrs, NO_VISITS);
    }

    public NodeFactory(int size, int children, int[] internalAttrs, Visits visits) {
        this.pool = new Node[size];
        this.children = children;
        this.internalAttrs = internalAttrs;
        this.visits = visits;
    }

    private Node allocate() {
        if (this.used == 0) {
            return new Node(this, this.children, this.internalAttrs.length, this.visits);
        }
        --this.used;
        Node node = this.pool[this.used];
        node.init();
        return node;
    }

    public void free(Node node) {
        if (this.used == this.pool.length) {
            return;
        }
        this.pool[this.used] = node;
        ++this.used;
    }

    public Node allocateTerminal(Scanner scanner, Object environment) {
        Node node = this.allocate();
        Position pos = node.position;
        scanner.getPosition(pos);
        Object[] attrs = node.attrs;
        int max = attrs.length;
        block8: for (int i = 0; i < max; ++i) {
            switch (this.internalAttrs[i]) {
                case 1: {
                    attrs[i] = scanner.getText();
                    continue block8;
                }
                case 2: {
                    attrs[i] = new Integer(pos.getLine());
                    continue block8;
                }
                case 3: {
                    attrs[i] = new Integer(pos.getColumn());
                    continue block8;
                }
                case 4: {
                    attrs[i] = new Integer(pos.getOffset());
                    continue block8;
                }
                case 5: {
                    attrs[i] = environment;
                    continue block8;
                }
                case 0: {
                    attrs[i] = null;
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return node;
    }

    public Node allocateNonterminal(Parser parser, Object environment) {
        Node node = this.allocate();
        Node[] children = node.children;
        Position pos = node.position;
        int i = children.length;
        if (i != 0) {
            do {
                children[--i] = (Node)parser.pop();
            } while (i > 0);
            pos.set(children[0].position);
        }
        Object[] attrs = node.attrs;
        int max = attrs.length;
        block9: for (i = 0; i < max; ++i) {
            switch (this.internalAttrs[i]) {
                case 1: {
                    attrs[i] = node.getText();
                    continue block9;
                }
                case 2: {
                    attrs[i] = new Integer(pos.getLine());
                    continue block9;
                }
                case 3: {
                    attrs[i] = new Integer(pos.getColumn());
                    continue block9;
                }
                case 4: {
                    attrs[i] = new Integer(pos.getOffset());
                    continue block9;
                }
                case 5: {
                    attrs[i] = environment;
                    continue block9;
                }
                case 0: {
                    attrs[i] = null;
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return node;
    }

    public static int lookupAttribute(String name) {
        if ("text".equals(name)) {
            return 1;
        }
        if ("line".equals(name)) {
            return 2;
        }
        if ("column".equals(name)) {
            return 3;
        }
        if ("offset".equals(name)) {
            return 4;
        }
        if ("env".equals(name)) {
            return 5;
        }
        return -1;
    }

    public static Class getDeclaration(int no) {
        switch (no) {
            case 1: {
                return String.class;
            }
            case 2: 
            case 3: 
            case 4: {
                return Integer.class;
            }
            case 5: {
                return Object.class;
            }
        }
        throw new IllegalArgumentException();
    }
}

