/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import java.io.PrintWriter;
import java.io.Serializable;
import net.oneandone.mork.parser.Parser;
import net.oneandone.mork.parser.ParserTable;
import net.oneandone.mork.parser.TreeBuilder;
import net.oneandone.mork.scanner.Scanner;
import net.oneandone.mork.semantics.Node;
import net.oneandone.mork.semantics.NodeFactory;
import net.oneandone.mork.semantics.SemanticError;
import net.oneandone.mork.semantics.Visits;

public class Oag
implements TreeBuilder,
Serializable {
    private transient PrintWriter logging;
    private transient NodeFactory[] terminals;
    private transient NodeFactory[] nonterminals;
    private transient Scanner scanner;
    private transient Parser parser;
    private transient Object environment;
    private final Visits[] visits;
    private final int[][] internalAttrs;

    public Oag(Visits[] visits, int[][] internalAttrs) {
        this.visits = visits;
        this.internalAttrs = internalAttrs;
        this.logging = null;
        this.terminals = null;
        this.nonterminals = null;
    }

    public void setEnvironment(Object environment) {
        this.environment = environment;
    }

    public void setLogging(PrintWriter logging) {
        this.logging = logging;
    }

    public Oag newInstance() {
        Oag oag = new Oag(this.newVisits(), this.internalAttrs);
        oag.setLogging(this.logging);
        return oag;
    }

    private Visits[] newVisits() {
        Visits[] result = new Visits[this.visits.length];
        for (int i = this.visits.length - 1; i >= 0; --i) {
            result[i] = this.visits[i].newInstance();
        }
        return result;
    }

    @Override
    public void open(Scanner scanner, Parser parser) {
        this.scanner = scanner;
        this.parser = parser;
        this.initFactories();
    }

    private void initFactories() {
        int i;
        if (this.nonterminals != null) {
            return;
        }
        ParserTable table = this.parser.getTable();
        this.nonterminals = new NodeFactory[this.visits.length];
        for (i = 0; i < this.nonterminals.length; ++i) {
            this.nonterminals[i] = new NodeFactory(10, table.getLength(i), this.internalAttrs[table.getLeft(i)], this.visits[i]);
        }
        this.terminals = new NodeFactory[this.internalAttrs.length];
        for (i = 0; i < this.terminals.length; ++i) {
            this.terminals[i] = new NodeFactory(5, this.internalAttrs[i]);
        }
    }

    @Override
    public Object createTerminal(int terminal) {
        return this.terminals[terminal].allocateTerminal(this.scanner, this.environment);
    }

    @Override
    public Object createNonterminal(int production) throws SemanticError {
        Node node = this.nonterminals[production].allocateNonterminal(this.parser, this.environment);
        node.compute(this.logging);
        return node;
    }

    public void printVisits(PrintWriter dest) {
        for (int i = 0; i < this.visits.length; ++i) {
            dest.print("prod ");
            dest.print(i);
            dest.print(": ");
            dest.print(this.visits[i].toString());
            dest.println();
        }
    }
}

