/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import net.oneandone.graph.EdgeIterator;
import net.oneandone.graph.Graph;
import net.oneandone.mork.grammar.Grammar;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.misc.StringArrayList;
import net.oneandone.mork.semantics.Ag;
import net.oneandone.mork.semantics.Attribute;
import net.oneandone.mork.semantics.AttributeOccurrence;
import net.oneandone.mork.semantics.AttributionBuffer;
import net.oneandone.mork.semantics.Layout;
import net.oneandone.mork.semantics.Partition;
import net.oneandone.mork.semantics.Visits;
import net.oneandone.sushi.util.IntBitSet;

public class OagBuilder {
    private final Ag semantics;
    private final Layout layout;
    private final Grammar grammar;
    private final IntBitSet symbols;

    public OagBuilder(Ag semantics, Layout layout) {
        this.semantics = semantics;
        this.layout = layout;
        this.grammar = semantics.getGrammar();
        this.symbols = new IntBitSet();
        this.grammar.getSymbols(this.symbols);
    }

    public static Visits[] run(Ag ag, Layout layout, PrintWriter verbose) throws GenericException {
        OagBuilder builder = new OagBuilder(ag, layout);
        Graph<AttributeOccurrence>[] dp = builder.createDP();
        Graph<AttributeOccurrence>[] idp = builder.createIDP(dp);
        Graph<Attribute>[] ids = builder.createIDS(idp);
        List<Attribute>[][] as = builder.createA(ids);
        Graph<Attribute>[] ds = builder.createDS(ids, as);
        Graph[] edp = builder.createEDP(dp, ds);
        Visits[] visits = builder.createVisits(edp, as);
        if (verbose != null) {
            int i;
            StringArrayList symbolTable = ag.getGrammar().getSymbolTable();
            for (i = 0; i < dp.length; ++i) {
                verbose.println("prod=" + i);
                verbose.println("  dp\t" + OagBuilder.aos(symbolTable, dp[i]));
                verbose.println("  idp\t" + OagBuilder.aos(symbolTable, idp[i]));
                verbose.println("  edp\t" + OagBuilder.aos(symbolTable, edp[i]));
            }
            for (i = 0; i < ids.length; ++i) {
                verbose.println(symbolTable.get(i) + ":");
                verbose.println(" ids\t" + OagBuilder.as(symbolTable, ids[i]));
                verbose.println(" as\t");
                OagBuilder.print(as[i], verbose);
                verbose.println(" ds\t" + OagBuilder.as(symbolTable, ds[i]));
            }
        }
        return visits;
    }

    private static void print(List[] as, PrintWriter dest) {
        for (int i = 0; i < as.length; ++i) {
            dest.print("\t\t" + i + ":");
            int max = as[i].size();
            for (int j = 0; j < max; ++j) {
                dest.print(' ');
                dest.print(((Attribute)as[i].get((int)j)).name);
            }
            dest.println();
        }
    }

    private static String as(StringArrayList symbolTable, Graph relation) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        EdgeIterator iter = relation.edges();
        while (iter.step()) {
            buffer.append(" (");
            Attribute a = (Attribute)iter.left();
            buffer.append(a.toString(symbolTable));
            buffer.append(", ");
            a = (Attribute)iter.right();
            buffer.append(a.toString(symbolTable));
            buffer.append(") ");
        }
        buffer.append('}');
        return buffer.toString();
    }

    private static String aos(StringArrayList symbolTable, Graph relation) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        EdgeIterator iter = relation.edges();
        while (iter.step()) {
            buffer.append(" (");
            AttributeOccurrence ao = (AttributeOccurrence)iter.left();
            buffer.append(ao.toString(symbolTable));
            buffer.append(", ");
            ao = (AttributeOccurrence)iter.right();
            buffer.append(ao.toString(symbolTable));
            buffer.append(") ");
        }
        buffer.append('}');
        return buffer.toString();
    }

    public Graph<AttributeOccurrence>[] createDP() {
        int i;
        Graph[] dp = new Graph[this.semantics.getGrammar().getProductionCount()];
        for (i = 0; i < dp.length; ++i) {
            dp[i] = new Graph();
        }
        int max = this.semantics.getSize();
        for (i = 0; i < max; ++i) {
            AttributionBuffer ab = this.semantics.get(i);
            this.addDP((Graph<AttributeOccurrence>)dp[ab.production], ab);
        }
        return dp;
    }

    private void addDP(Graph<AttributeOccurrence> dp, AttributionBuffer ab) {
        int max = ab.getArgCount();
        for (int i = 0; i < max; ++i) {
            dp.addEdge((Object)ab.getArg(i), (Object)ab.result);
        }
    }

    public Graph<AttributeOccurrence>[] createIDP(Graph<AttributeOccurrence>[] dp) {
        boolean modified;
        int p;
        Graph[] idp = new Graph[dp.length];
        Graph[] idpClosure = new Graph[dp.length];
        boolean[] touched = new boolean[dp.length];
        for (p = 0; p < idp.length; ++p) {
            idp[p] = new Graph();
            idp[p].addGraph(dp[p]);
            idpClosure[p] = new Graph();
            idpClosure[p].addGraph(dp[p]);
            idpClosure[p].closureHere();
            touched[p] = true;
        }
        do {
            modified = false;
            for (int q = 0; q < idp.length; ++q) {
                if (!touched[q]) continue;
                touched[q] = false;
                EdgeIterator iter = idpClosure[q].edges();
                while (iter.step()) {
                    AttributeOccurrence right;
                    AttributeOccurrence left = (AttributeOccurrence)iter.left();
                    if (!left.sameSymbolOccurrence(right = (AttributeOccurrence)iter.right())) continue;
                    for (p = 0; p < idp.length; ++p) {
                        for (int ofs = 0; ofs <= this.grammar.getLength(p); ++ofs) {
                            AttributeOccurrence newRight;
                            AttributeOccurrence newLeft;
                            int symbol = this.semantics.getGrammar().getSymbol(p, ofs);
                            if (symbol != left.attr.symbol || !idp[p].addEdge((Object)(newLeft = new AttributeOccurrence(left.attr, ofs - 1)), (Object)(newRight = new AttributeOccurrence(right.attr, ofs - 1)))) continue;
                            idpClosure[p].addEdge((Object)newLeft, (Object)newRight);
                            idpClosure[p].closureHere();
                            touched[p] = true;
                            modified = true;
                        }
                    }
                }
            }
        } while (modified);
        return idp;
    }

    public Graph<Attribute>[] createIDS(Graph<AttributeOccurrence>[] idp) {
        Graph[] ids = new Graph[this.symbols.last() + 1];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = new Graph();
        }
        for (int p = 0; p < idp.length; ++p) {
            EdgeIterator iter = idp[p].edges();
            while (iter.step()) {
                AttributeOccurrence right;
                AttributeOccurrence left = (AttributeOccurrence)iter.left();
                if (!left.sameSymbolOccurrence(right = (AttributeOccurrence)iter.right())) continue;
                ids[left.attr.symbol].addEdge((Object)left.attr, (Object)right.attr);
            }
        }
        return ids;
    }

    public List<Attribute>[][] createA(Graph<Attribute>[] ids) throws GenericException {
        HashSet<Attribute> internal = new HashSet<Attribute>();
        HashSet<Attribute> inherited = new HashSet<Attribute>();
        HashSet<Attribute> synthesized = new HashSet<Attribute>();
        List[][] result = new List[ids.length][];
        for (int i = 0; i < ids.length; ++i) {
            internal.clear();
            inherited.clear();
            synthesized.clear();
            this.semantics.getAttributes(i, internal, synthesized, inherited);
            synthesized.addAll(internal);
            result[i] = Partition.createA(synthesized, inherited, ids[i]);
        }
        return result;
    }

    public Graph<Attribute>[] createDS(Graph<Attribute>[] ids, List<Attribute>[][] a) {
        Graph[] ds = new Graph[ids.length];
        for (int i = 0; i < ds.length; ++i) {
            ds[i] = this.createDSx(ids[i], a[i]);
        }
        return ds;
    }

    private Graph<Attribute> createDSx(Graph<Attribute> ids, List<Attribute>[] a) {
        Graph ds = new Graph();
        ds.addGraph(ids);
        for (int i = 1; i < a.length; ++i) {
            List<Attribute> leftList = a[i];
            int leftSize = leftList.size();
            List<Attribute> rightList = a[i - 1];
            int rightSize = rightList.size();
            for (int left = 0; left < leftSize; ++left) {
                for (int right = 0; right < rightSize; ++right) {
                    ds.addEdge((Object)leftList.get(left), (Object)rightList.get(right));
                }
            }
        }
        return ds;
    }

    public Graph[] createEDP(Graph[] dp, Graph<Attribute>[] ds) {
        Graph[] eds = new Graph[dp.length];
        for (int i = 0; i < eds.length; ++i) {
            eds[i] = this.createEDPx(i, (Graph<AttributeOccurrence>)dp[i], ds);
        }
        return eds;
    }

    private Graph<AttributeOccurrence> createEDPx(int p, Graph<AttributeOccurrence> dp, Graph<Attribute>[] ds) {
        Graph edsP = new Graph();
        edsP.addGraph(dp);
        int maxOfs = this.semantics.getGrammar().getLength(p);
        for (int ofs = 0; ofs <= maxOfs; ++ofs) {
            int symbol = this.semantics.getGrammar().getSymbol(p, ofs);
            EdgeIterator iter = ds[symbol].edges();
            while (iter.step()) {
                edsP.addEdge((Object)new AttributeOccurrence((Attribute)iter.left(), ofs - 1), (Object)new AttributeOccurrence((Attribute)iter.right(), ofs - 1));
            }
        }
        return edsP;
    }

    public Visits[] createVisits(Graph<AttributeOccurrence>[] edp, List<Attribute>[][] as) throws GenericException {
        Visits[] visits = new Visits[edp.length];
        for (int p = 0; p < edp.length; ++p) {
            visits[p] = Visits.forEDP(p, edp[p], this.semantics, as, this.layout);
        }
        return visits;
    }
}

