/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import java.util.List;

public class Occurrence {
    public static final int UNBOUNDED = Integer.MAX_VALUE;
    public static final Occurrence ONE = new Occurrence(1, 1);
    public final int min;
    public final int max;

    public Occurrence(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public int card() {
        if (this.max > 1) {
            return 2;
        }
        if (this.min == 0) {
            return 1;
        }
        return 0;
    }

    public static Occurrence sequence(List occs) {
        int size = occs.size();
        int min = 0;
        int max = 0;
        int recursion = 0;
        for (int i = 0; i < size; ++i) {
            Occurrence occ = (Occurrence)occs.get(i);
            if (occ == null) {
                ++recursion;
                continue;
            }
            min += occ.min;
            if (occ.max == Integer.MAX_VALUE) {
                max = Integer.MAX_VALUE;
                continue;
            }
            max += occ.max;
        }
        if (recursion > 0) {
            if (recursion == size) {
                return null;
            }
            return new Occurrence(min, Integer.MAX_VALUE);
        }
        return new Occurrence(min, max);
    }

    public static Occurrence alternate(List<Occurrence> occs) {
        int size = occs.size();
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        boolean defined = false;
        for (int i = 0; i < size; ++i) {
            Occurrence occ = occs.get(i);
            if (occ == null) continue;
            min = Math.min(occ.min, min);
            max = Math.max(occ.max, max);
            defined = true;
        }
        if (defined) {
            return new Occurrence(min, max);
        }
        return null;
    }

    public String toString() {
        return this.min + ":" + this.max;
    }
}

