/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.oneandone.graph.EdgeIterator;
import net.oneandone.graph.Graph;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.semantics.Attribute;

public class Partition {
    public static List<Attribute>[] createA(Set synthesized, Set inherited, Graph idsX) throws GenericException {
        Graph closure = new Graph();
        closure.addGraph(idsX);
        ArrayList<List> partitions = new ArrayList<List>();
        ArrayList done = new ArrayList();
        int all = inherited.size() + synthesized.size();
        while (done.size() < all) {
            int initialSize = done.size();
            partitions.add(Partition.extractStep(synthesized, done, closure));
            if (done.size() == all) break;
            partitions.add(Partition.extractStep(inherited, done, closure));
            if (initialSize != done.size()) continue;
            throw new GenericException("cyclic dependency");
        }
        List[] result = new List[partitions.size()];
        partitions.toArray(result);
        return result;
    }

    private static List extractStep(Collection lefts, Collection rights, Graph relation) {
        ArrayList all = new ArrayList();
        List current;
        while ((current = Partition.getDisconnected(lefts, relation, rights)).size() != 0) {
            lefts.removeAll(current);
            rights.addAll(current);
            all.addAll(current);
        }
        return all;
    }

    public static List getDisconnected(Collection leftCollection, Graph relation, Collection rightCollection) {
        ArrayList disconnected = new ArrayList();
        for (Object left : leftCollection) {
            EdgeIterator relationIter = relation.edges();
            while (relationIter.step()) {
                if (relationIter.left() != left || rightCollection.contains(relationIter.right())) continue;
                relationIter = null;
                break;
            }
            if (relationIter == null) continue;
            disconnected.add(left);
        }
        return disconnected;
    }
}

