/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.mork.grammar.Grammar;
import net.oneandone.mork.semantics.AgBuffer;
import net.oneandone.mork.semantics.Attribute;
import net.oneandone.mork.semantics.State;
import net.oneandone.sushi.util.IntBitSet;

public class Pusher {
    private final List<State> states = new ArrayList<State>();
    private final IntBitSet border;
    private final Grammar grammar;

    public static AgBuffer run(boolean down, Attribute seed, IntBitSet border, Grammar grm) {
        Pusher pusher = new Pusher(seed, border, grm);
        if (down) {
            pusher.pushDown();
        } else {
            pusher.pushUp();
        }
        pusher.states.remove(0);
        return new AgBuffer(pusher.states);
    }

    private Pusher(Attribute seed, IntBitSet border, Grammar grammar) {
        this.states.add(new State(seed));
        this.border = border;
        this.grammar = grammar;
    }

    private void pushUp() {
        for (int i = 0; i < this.states.size(); ++i) {
            State state = this.states.get(i);
            Attribute attr = state.getAttribute();
            if (i != 0 && this.border.contains(attr.symbol)) continue;
            int max = this.grammar.getUserCount(attr.symbol);
            for (int user = 0; user < max; ++user) {
                this.pushUp(user, i);
            }
        }
    }

    private void pushUp(int user, int attrIdx) {
        State child = this.states.get(attrIdx);
        Attribute childAttr = child.getAttribute();
        int prod = this.grammar.getUser(childAttr.symbol, user);
        int symbol = this.grammar.getLeft(prod);
        int max = this.grammar.getUserOfsCount(childAttr.symbol, user);
        for (int idx = 0; idx < max; ++idx) {
            State parent = this.findState(1, symbol);
            if (parent == null) {
                parent = new State(true, new Attribute(symbol, "transport"), this.grammar);
                this.states.add(parent);
            }
            int ofs = this.grammar.getUserOfs(childAttr.symbol, user, idx);
            parent.addUpTransport(prod, ofs, childAttr);
        }
    }

    private void pushDown() {
        for (int i = 0; i < this.states.size(); ++i) {
            Attribute attr = this.states.get(i).getAttribute();
            if (i != 0 && this.border.contains(attr.symbol)) continue;
            int max = this.grammar.getAlternativeCount(attr.symbol);
            for (int alt = 0; alt < max; ++alt) {
                this.pushDown(alt, i);
            }
        }
    }

    private void pushDown(int alt, int attrIdx) {
        State parent = this.states.get(attrIdx);
        Attribute parentAttr = parent.getAttribute();
        int prod = this.grammar.getAlternative(parentAttr.symbol, alt);
        int max = this.grammar.getLength(prod);
        for (int ofs = 0; ofs < max; ++ofs) {
            int symbol = this.grammar.getRight(prod, ofs);
            State child = this.findState(1, symbol);
            if (child == null) {
                child = new State(false, new Attribute(symbol, "transport"), this.grammar);
                this.states.add(child);
            }
            child.addDownTransport(prod, ofs, parentAttr);
        }
    }

    private State findState(int ofs, int symbol) {
        int max = this.states.size();
        for (int i = ofs; i < max; ++i) {
            State state = this.states.get(i);
            if (state.getAttribute().symbol != symbol) continue;
            return state;
        }
        return null;
    }
}

