/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.oneandone.mork.grammar.Grammar;
import net.oneandone.mork.mapping.Transport;
import net.oneandone.mork.reflect.Function;
import net.oneandone.mork.reflect.Identity;
import net.oneandone.mork.semantics.Ag;
import net.oneandone.mork.semantics.AgBuffer;
import net.oneandone.mork.semantics.Alternative;
import net.oneandone.mork.semantics.Attribute;
import net.oneandone.mork.semantics.AttributeOccurrence;
import net.oneandone.mork.semantics.AttributionBuffer;
import net.oneandone.mork.semantics.Compare;
import net.oneandone.mork.semantics.Merger;
import net.oneandone.mork.semantics.Occurrence;
import net.oneandone.sushi.util.IntArrayList;

public class State
implements Compare {
    private final List<Alternative> alternatives;
    public int minOcc;
    public int maxOcc;
    public final Attribute transportAttribute;
    private static final Function TMP_FUNCTION = new Identity("tmp", Object.class);

    public State(Attribute attribute) {
        this.transportAttribute = attribute;
        this.alternatives = new ArrayList<Alternative>();
    }

    public State(State orig) {
        this.transportAttribute = orig.transportAttribute;
        this.alternatives = new ArrayList<Alternative>();
        int max = orig.alternatives.size();
        for (int i = 0; i < max; ++i) {
            this.alternatives.add(orig.alternatives.get(i));
        }
    }

    public static State cloneEmpty(State orig) {
        Attribute attr = new Attribute(orig.transportAttribute);
        State clone = new State(attr);
        int max = orig.alternatives.size();
        for (int i = 0; i < max; ++i) {
            Alternative old = orig.alternatives.get(i);
            clone.alternatives.add(new Alternative(old.production, old.resultOfs));
        }
        return clone;
    }

    public State(boolean up, Attribute attr, Grammar grm) {
        this.transportAttribute = attr;
        this.alternatives = new ArrayList<Alternative>();
        if (up) {
            this.addSynthesized(attr.symbol, grm);
        } else {
            this.addInherited(attr.symbol, grm);
        }
    }

    private void addSynthesized(int symbol, Grammar grm) {
        int max = grm.getAlternativeCount(symbol);
        for (int i = 0; i < max; ++i) {
            Alternative ab = new Alternative(grm.getAlternative(symbol, i), -1);
            this.alternatives.add(ab);
        }
    }

    private void addInherited(int symbol, Grammar grm) {
        int maxUser = grm.getUserCount(symbol);
        for (int user = 0; user < maxUser; ++user) {
            int prod = grm.getUser(symbol, user);
            int maxIdx = grm.getUserOfsCount(symbol, user);
            for (int idx = 0; idx < maxIdx; ++idx) {
                int ofs = grm.getUserOfs(symbol, user, idx);
                Alternative ab = new Alternative(prod, ofs);
                this.alternatives.add(ab);
            }
        }
    }

    public void addUpTransport(int prod, int ofs, Attribute child) {
        int max = this.alternatives.size();
        for (int i = 0; i < max; ++i) {
            Alternative ab = this.alternatives.get(i);
            if (ab.production != prod) continue;
            ab.add(ofs, child);
        }
    }

    public void addDownTransport(int prod, int ofs, Attribute parent) {
        int max = this.alternatives.size();
        for (int i = 0; i < max; ++i) {
            Alternative ab = this.alternatives.get(i);
            if (ab.resultOfs != ofs || ab.production != prod) continue;
            ab.add(-1, parent);
        }
    }

    public Attribute getAttribute() {
        return this.transportAttribute;
    }

    public void createSemanticsBuffer(Ag sems, Transport transport) {
        int max = this.alternatives.size();
        for (int i = 0; i < max; ++i) {
            Alternative old = this.alternatives.get(i);
            AttributionBuffer replacement = new AttributionBuffer(old.production, TMP_FUNCTION, new AttributeOccurrence(this.transportAttribute, old.resultOfs));
            int maxJ = old.getArgCount();
            ArrayList<Attribute> args = new ArrayList<Attribute>();
            for (int j = 0; j < maxJ; ++j) {
                Attribute tmp = old.getArgAttribute(j);
                replacement.add(new AttributeOccurrence(tmp, old.getArgOfs(j)));
                args.add(tmp);
            }
            replacement.function = transport.getTransportFn(args, this.transportAttribute.type.card);
            sems.add(replacement);
        }
    }

    public void addArgAttrs(List<Attribute> result) {
        int max = this.alternatives.size();
        for (int i = 0; i < max; ++i) {
            Alternative ab = this.alternatives.get(i);
            ab.addArgAttrs(result);
        }
    }

    public boolean isDownOptional() {
        int max = this.alternatives.size();
        for (int i = 0; i < max; ++i) {
            Alternative ab = this.alternatives.get(i);
            if (ab.getArgCount() != 0) continue;
            return true;
        }
        return false;
    }

    public int compare(State rightState, List<Attribute> nextLefts, List<Attribute> nextRights) {
        Alternative right;
        Alternative left;
        int i;
        int max = this.alternatives.size();
        if (max != rightState.alternatives.size()) {
            throw new IllegalStateException("different number of productions");
        }
        int result = 0;
        for (i = 0; i < max; ++i) {
            left = this.alternatives.get(i);
            if (((result |= left.compare(right = rightState.alternatives.get(i))) & 8) != 8 && (result & 6) != 6) continue;
            return 8;
        }
        if ((result & 2) == 2) {
            return 2;
        }
        if ((result & 4) == 4) {
            return 4;
        }
        if (result == 16) {
            return 1;
        }
        if (result != 0 && (result & 1) == 0) {
            throw new IllegalStateException();
        }
        for (i = 0; i < max; ++i) {
            left = this.alternatives.get(i);
            right = rightState.alternatives.get(i);
            if (left.getArgCount() != 1 || right.getArgCount() != 1) continue;
            left.addArgAttrs(nextLefts);
            right.addArgAttrs(nextRights);
            if (nextLefts.size() == nextRights.size()) continue;
            System.err.println("TODO: left.size() != right.size()");
            return 8;
        }
        return 1;
    }

    public State cloneAttributeTransport(Map<Attribute, Attribute> map) {
        Attribute replacedResult = map.get(this.getAttribute());
        int max = this.alternatives.size();
        State result = new State(replacedResult);
        for (int i = 0; i < max; ++i) {
            Alternative old = this.alternatives.get(i);
            Alternative replacement = new Alternative(old.production, old.resultOfs);
            int maxJ = old.getArgCount();
            for (int j = 0; j < maxJ; ++j) {
                Attribute tmp = old.getArgAttribute(j);
                Attribute replacedArg = map.get(tmp);
                replacement.add(old.getArgOfs(j), replacedArg != null ? replacedArg : tmp);
            }
            result.alternatives.add(replacement);
        }
        return result;
    }

    public Occurrence calcOccurrence(AgBuffer copyBuffer, List<Attribute> stack) {
        ArrayList<Occurrence> alt = new ArrayList<Occurrence>();
        for (int i = 0; i < this.alternatives.size(); ++i) {
            Alternative ab = this.alternatives.get(i);
            int max = ab.getArgCount();
            ArrayList<Occurrence> seq = new ArrayList<Occurrence>();
            for (int j = 0; j < max; ++j) {
                Attribute next = ab.getArgAttribute(j);
                if (stack.indexOf(next) == -1) {
                    seq.add(copyBuffer.calcOccurrence(stack, next));
                    continue;
                }
                seq.add(null);
            }
            Occurrence occ = Occurrence.sequence(seq);
            alt.add(occ);
        }
        return Occurrence.alternate(alt);
    }

    public static State merge(Map<Attribute, Merger> mapping, List<State> copies) {
        if (copies.size() == 0) {
            throw new IllegalStateException();
        }
        State first = copies.get(0);
        State result = new State(Merger.map(mapping, first.getAttribute()));
        int attribSize = first.alternatives.size();
        int copiesSize = copies.size();
        for (int a = 0; a < attribSize; ++a) {
            Alternative firstAb = first.alternatives.get(a);
            Alternative destAb = new Alternative(firstAb.production, firstAb.resultOfs);
            for (int c = 0; c < copiesSize; ++c) {
                State current = copies.get(c);
                Alternative srcAb = current.alternatives.get(a);
                State.addMappedArguments(srcAb, destAb, mapping);
            }
            result.alternatives.add(destAb);
        }
        return result;
    }

    private static Alternative addMappedArguments(Alternative ab, Alternative dest, Map<Attribute, Merger> mapping) {
        int max = ab.getArgCount();
        for (int i = 0; i < max; ++i) {
            Attribute attr = Merger.map(mapping, ab.getArgAttribute(i));
            if (dest.contains(ab.getArgOfs(i), attr)) continue;
            dest.add(ab.getArgOfs(i), attr);
        }
        return ab;
    }

    public void getSequence(int seq, List<Attribute> nextAttrs, IntArrayList nextOfss, IntArrayList nextSeqs, AgBuffer cb) {
        int max = this.alternatives.size();
        for (int i = 0; i < max; ++i) {
            State.getSequence(this.alternatives.get(i), seq, nextAttrs, nextOfss, nextSeqs, cb);
        }
    }

    private static void getSequence(Alternative ab, int seq, List<Attribute> nextAttrs, IntArrayList nextOfss, IntArrayList nextSeqs, AgBuffer cb) {
        int max = ab.getArgCount();
        for (int i = 0; i < max; ++i) {
            Attribute attr = ab.getArgAttribute(i);
            int width = cb.getWidth(attr);
            if (seq < width) {
                nextAttrs.add(attr);
                nextOfss.add(ab.getArgOfs(i));
                nextSeqs.add(seq);
                return;
            }
            seq -= width;
        }
        nextAttrs.add(null);
        nextOfss.add(-1);
        nextSeqs.add(-1);
    }

    public void addBlind(int i, Attribute attr, int ofs) {
        Alternative ab = this.alternatives.get(i);
        ab.add(ofs, attr);
    }

    public boolean recalcOccurrence(AgBuffer cb) {
        int oldMin = this.minOcc;
        int oldMax = this.maxOcc;
        int max = this.alternatives.size();
        this.minOcc = State.calcOcc(this.alternatives.get(0), false, cb);
        this.maxOcc = State.calcOcc(this.alternatives.get(0), true, cb);
        for (int i = 1; i < max; ++i) {
            Alternative ab = this.alternatives.get(i);
            this.minOcc = Math.min(State.calcOcc(ab, false, cb), this.minOcc);
            this.maxOcc = Math.max(State.calcOcc(ab, true, cb), this.maxOcc);
        }
        return oldMin != this.minOcc || oldMax != this.maxOcc;
    }

    private static int calcOcc(Alternative ab, boolean calcMax, AgBuffer cb) {
        int occ = 0;
        int max = ab.getArgCount();
        for (int i = 0; i < max; ++i) {
            State state = cb.lookup(ab.getArgAttribute(i));
            if (state != null) {
                occ += calcMax ? state.maxOcc : state.minOcc;
                continue;
            }
            ++occ;
        }
        return occ;
    }

    public String toRawString() {
        return this.toString(true);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean raw) {
        StringBuilder buf = new StringBuilder();
        int max = this.alternatives.size();
        for (int i = 0; i < max; ++i) {
            Alternative ab = this.alternatives.get(i);
            buf.append("  ");
            if (raw) {
                buf.append(ab.toRawString());
            } else {
                buf.append(ab.toString());
            }
            buf.append('\n');
        }
        return buf.toString();
    }
}

