/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import net.oneandone.mork.classfile.ClassRef;

public class Type {
    public static final int VALUE = 0;
    public static final int OPTION = 1;
    public static final int SEQUENCE = 2;
    public final Class type;
    public final int card;

    public Type(Class type) {
        this(type, 0);
    }

    public Type(Class type, int card) {
        if (type.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.card = card;
    }

    public static int cardCard(int first, int second) {
        if (first == 2 || second == 2) {
            return 2;
        }
        if (first == 1 || second == 1) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Type) {
            Type operand = (Type)obj;
            return this.card == operand.card && this.type.equals(operand.type);
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public Type option() {
        if (this.card >= 1) {
            return this;
        }
        return new Type(this.type, 1);
    }

    public Type sequence() {
        return new Type(this.type, 2);
    }

    public Type alternate(Type operand) {
        Class<?> tmp = ClassRef.commonBase(this.type, operand.type);
        return new Type(tmp, Math.max(this.card, operand.card));
    }

    public String toString() {
        return this.type.getName() + this.cardString();
    }

    public String cardString() {
        switch (this.card) {
            case 0: {
                return "";
            }
            case 1: {
                return "?";
            }
            case 2: {
                return "*";
            }
        }
        throw new RuntimeException();
    }
}

