/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.mork.semantics;

import java.util.LinkedHashSet;
import java.util.List;
import net.oneandone.graph.CyclicDependency;
import net.oneandone.graph.EdgeIterator;
import net.oneandone.graph.Graph;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.mork.semantics.Ag;
import net.oneandone.mork.semantics.Attribute;
import net.oneandone.mork.semantics.AttributeOccurrence;
import net.oneandone.mork.semantics.Attribution;
import net.oneandone.mork.semantics.AttributionBuffer;
import net.oneandone.mork.semantics.Layout;
import net.oneandone.sushi.util.Util;

public class Visits {
    private final Object[] visits;

    public static Visits forEDP(int prod, Graph<AttributeOccurrence> edp, Ag sems, List<Attribute>[][] as, Layout layout) throws GenericException {
        Object obj;
        int i;
        List lst;
        Graph visitRelation = new Graph();
        LinkedHashSet<AttributionBuffer> all = new LinkedHashSet<AttributionBuffer>();
        sems.getProduction(prod, all);
        for (Object e : all) {
            visitRelation.addNode(e);
        }
        EdgeIterator iter = edp.edges();
        while (iter.step()) {
            AttributeOccurrence left = (AttributeOccurrence)iter.left();
            AttributeOccurrence right = (AttributeOccurrence)iter.right();
            Object leftMapped = Visits.map(prod, left, sems, as);
            Object rightMapped = Visits.map(prod, right, sems, as);
            visitRelation.addEdge(leftMapped, rightMapped);
        }
        visitRelation.removeDirectCycles();
        try {
            lst = visitRelation.sort();
        }
        catch (CyclicDependency e) {
            throw new GenericException("cyclic dependency in prod " + prod);
        }
        if (layout != null) {
            int max = lst.size();
            for (i = 0; i < max; ++i) {
                obj = lst.get(i);
                if (!(obj instanceof AttributionBuffer)) continue;
                lst.set(i, layout.createAttribution((AttributionBuffer)obj));
            }
        }
        for (i = lst.size() - 1; i >= 0; --i) {
            obj = lst.get(i);
            if (obj instanceof Attribute) {
                lst.remove(i);
                continue;
            }
            if (obj instanceof Integer) {
                if (Visits.getPreNo(obj) == 0) {
                    if (Visits.getPreOfs(obj) == -1) {
                        throw new IllegalStateException();
                    }
                    lst.remove(i);
                    continue;
                }
                lst.set(i, Visits.createVisit(Visits.getPreOfs(obj)));
                continue;
            }
            if (!(obj instanceof Attribution)) continue;
        }
        return new Visits(lst.toArray());
    }

    public Visits(Object[] visits) {
        this.visits = visits;
    }

    public Visits newInstance() {
        Object[] copy = new Object[this.visits.length];
        for (int i = this.visits.length - 1; i >= 0; --i) {
            Object obj = this.visits[i];
            copy[i] = obj instanceof Attribution ? ((Attribution)obj).newInstance() : obj;
        }
        return new Visits(copy);
    }

    public Object get(int idx) {
        return this.visits[idx];
    }

    public int size() {
        return this.visits.length;
    }

    public static Object map(int prod, AttributeOccurrence ao, Ag sems, List<Attribute>[][] as) {
        if (sems.isInternal(ao.attr)) {
            return ao.attr;
        }
        AttributionBuffer ab = sems.findDefinition(prod, ao);
        if (ab != null) {
            return ab;
        }
        int symbol = ao.attr.symbol;
        int m = Util.find((List[])as[symbol], (Object)ao.attr);
        if (m == -1) {
            throw new IllegalArgumentException("not found: " + ao.attr);
        }
        ++m;
        int fx = as[symbol].length;
        if ((fx & 1) == 0) {
            ++fx;
        }
        int no = (fx - m + 1) / 2;
        return Visits.createPreVisit(no, ao.ofs);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int max = this.visits.length;
        for (int i = 0; i < max; ++i) {
            Object obj;
            if (i > 0) {
                buffer.append(' ');
            }
            if ((obj = this.visits[i]) instanceof Integer) {
                int ofs = Visits.getPreOfs(obj);
                int no = Visits.getPreNo(obj);
                buffer.append(no);
                buffer.append(':');
                if (ofs == -1) {
                    buffer.append('^');
                    continue;
                }
                buffer.append('!');
                buffer.append(ofs);
                continue;
            }
            buffer.append(obj.toString());
        }
        return buffer.toString();
    }

    public static Integer createVisit(int ofs) {
        return new Integer(ofs);
    }

    public static int getOfs(Object visit) {
        return (Integer)visit;
    }

    public static Integer createPreVisit(int no, int ofs) {
        return new Integer((ofs << 16) + no);
    }

    public static int getPreNo(Object preVisit) {
        return (Integer)preVisit & 0xFFFF;
    }

    public static int getPreOfs(Object preVisit) {
        return (Integer)preVisit >> 16;
    }
}

