/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.RetryPolicy;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import net.oneandone.troilus.Context;
import net.oneandone.troilus.ListenableFutures;
import net.oneandone.troilus.Result;

abstract class AbstractQuery<Q> {
    private final Context ctx;

    AbstractQuery(Context ctx) {
        this.ctx = ctx;
    }

    protected abstract Q newQuery(Context var1);

    public Q withConsistency(ConsistencyLevel consistencyLevel) {
        return this.newQuery(this.ctx.withConsistency(consistencyLevel));
    }

    public Q withTracking() {
        return this.newQuery(this.ctx.withEnableTracking());
    }

    public Q withoutTracking() {
        return this.newQuery(this.ctx.withDisableTracking());
    }

    public Q withRetryPolicy(RetryPolicy policy) {
        return this.newQuery(this.ctx.withRetryPolicy(policy));
    }

    public Q withWritetime(long writetimeMicrosSinceEpoch) {
        return this.newQuery(this.getContext().withWritetime(writetimeMicrosSinceEpoch));
    }

    public Q withSerialConsistency(ConsistencyLevel consistencyLevel) {
        return this.newQuery(this.getContext().withSerialConsistency(consistencyLevel));
    }

    protected Context getContext() {
        return this.ctx;
    }

    protected ListenableFuture<ResultSet> performAsync(ListenableFuture<Statement> statementFuture) {
        Function<Statement, ListenableFuture<ResultSet>> statementToResultSetFuture = new Function<Statement, ListenableFuture<ResultSet>>(){

            public ListenableFuture<ResultSet> apply(Statement statement) {
                return AbstractQuery.this.performAsync(statement);
            }
        };
        return ListenableFutures.transform(statementFuture, statementToResultSetFuture, MoreExecutors.directExecutor());
    }

    protected ListenableFuture<ResultSet> performAsync(Statement statement) {
        if (this.getContext().getConsistencyLevel() != null) {
            statement.setConsistencyLevel(this.getContext().getConsistencyLevel());
        }
        if (this.getContext().getWritetime() != null) {
            statement.setDefaultTimestamp(this.getContext().getWritetime().longValue());
        }
        if (this.getContext().getRetryPolicy() != null) {
            statement.setRetryPolicy(this.getContext().getRetryPolicy());
        }
        if (this.getContext().getEnableTracing() != null) {
            if (this.getContext().getEnableTracing().booleanValue()) {
                statement.enableTracing();
            } else {
                statement.disableTracing();
            }
        }
        return this.ctx.getDbSession().getSession().executeAsync(statement);
    }

    Result newResult(ResultSet rs) {
        return new ResultImpl(rs);
    }

    private static class ResultImpl
    implements Result {
        private final ResultSet rs;

        ResultImpl(ResultSet rs) {
            this.rs = rs;
        }

        @Override
        public boolean wasApplied() {
            return this.rs.wasApplied();
        }

        @Override
        public ExecutionInfo getExecutionInfo() {
            return this.rs.getExecutionInfo();
        }

        @Override
        public ImmutableList<ExecutionInfo> getAllExecutionInfo() {
            return ImmutableList.copyOf((Collection)this.rs.getAllExecutionInfo());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (ExecutionInfo info : this.getAllExecutionInfo()) {
                builder.append("queried=" + info.getQueriedHost());
                builder.append("\r\ntried=").append(Joiner.on((String)",").join((Iterable)info.getTriedHosts()));
                if (info.getAchievedConsistencyLevel() != null) {
                    builder.append("\r\nachievedConsistencyLevel=" + info.getAchievedConsistencyLevel());
                }
                if (info.getQueryTrace() == null) continue;
                builder.append("\r\ntraceid=" + info.getQueryTrace().getTraceId());
                builder.append("\r\nevents:\r\n" + Joiner.on((String)"\r\n").join((Iterable)info.getQueryTrace().getEvents()));
            }
            return builder.toString();
        }
    }
}

