/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import net.oneandone.troilus.AbstractQuery;
import net.oneandone.troilus.BatchQueryFutureAdapter;
import net.oneandone.troilus.Batchable;
import net.oneandone.troilus.Context;
import net.oneandone.troilus.Immutables;
import net.oneandone.troilus.ListenableFutures;
import net.oneandone.troilus.Result;
import net.oneandone.troilus.java7.BatchMutation;

class BatchMutationQuery
extends AbstractQuery<BatchMutation>
implements BatchMutation {
    private final ImmutableList<Batchable> batchables;
    private final BatchStatement.Type type;

    BatchMutationQuery(Context ctx, BatchStatement.Type type, ImmutableList<Batchable> batchables) {
        super(ctx);
        this.type = type;
        this.batchables = batchables;
    }

    @Override
    protected BatchMutationQuery newQuery(Context newContext) {
        return new BatchMutationQuery(newContext, this.type, this.batchables);
    }

    public BatchMutationQuery withWriteAheadLog() {
        return new BatchMutationQuery(this.getContext(), BatchStatement.Type.LOGGED, this.batchables);
    }

    public BatchMutationQuery withoutWriteAheadLog() {
        return new BatchMutationQuery(this.getContext(), BatchStatement.Type.UNLOGGED, this.batchables);
    }

    @Override
    public BatchMutationQuery combinedWith(Batchable other) {
        return new BatchMutationQuery(this.getContext(), this.type, Immutables.merge(this.batchables, other));
    }

    @Override
    public Result execute() {
        return ListenableFutures.getUninterruptibly(this.executeAsync());
    }

    @Override
    public ListenableFuture<Result> executeAsync() {
        ListenableFuture<ResultSet> future = this.performAsync(this.getStatementAsync());
        Function<ResultSet, Result> mapEntity = new Function<ResultSet, Result>(){

            public Result apply(ResultSet resultSet) {
                return BatchMutationQuery.this.newResult(resultSet);
            }
        };
        return Futures.transform(future, (Function)mapEntity);
    }

    private ListenableFuture<Statement> getStatementAsync() {
        return new BatchQueryFutureAdapter(new BatchStatement(this.type), this.batchables.iterator());
    }
}

