/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.Statement;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutionException;
import net.oneandone.troilus.ListenableFutures;
import net.oneandone.troilus.StatementSource;

class BatchQueryFutureAdapter<T extends StatementSource>
extends AbstractFuture<Statement> {
    BatchQueryFutureAdapter(BatchStatement batchStmt, UnmodifiableIterator<T> batchablesIt) {
        this.handle(batchStmt, batchablesIt);
    }

    private void handle(final BatchStatement batchStmt, final UnmodifiableIterator<T> batchablesIt) {
        if (batchablesIt.hasNext()) {
            final ListenableFuture<Statement> statementFuture = ((StatementSource)batchablesIt.next()).getStatementAsync();
            Runnable resultHandler = new Runnable(){

                @Override
                public void run() {
                    try {
                        batchStmt.add((Statement)statementFuture.get());
                        BatchQueryFutureAdapter.this.handle(batchStmt, batchablesIt);
                    }
                    catch (InterruptedException | RuntimeException | ExecutionException e) {
                        BatchQueryFutureAdapter.this.setException(ListenableFutures.unwrapIfNecessary(e));
                    }
                }
            };
            statementFuture.addListener(resultHandler, MoreExecutors.directExecutor());
        } else {
            this.set(batchStmt);
        }
    }
}

