/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.oneandone.troilus.Field;
import net.oneandone.troilus.PropertiesSource;

class BeanMapper {
    private final LoadingCache<Class<?>, PropertiesMapper> propertiesMapperCache = CacheBuilder.newBuilder().build((CacheLoader)new PropertiesMapperLoader());

    BeanMapper() {
    }

    public ImmutableMap<String, Optional<Object>> toValues(Object entity, ImmutableSet<String> namesToMap) {
        return this.getPropertiesMapper(entity.getClass()).toValues(entity, namesToMap);
    }

    public <T> T fromValues(Class<?> clazz, PropertiesSource datasource, ImmutableSet<String> propertyNames) {
        return this.getPropertiesMapper(clazz).fromValues(datasource, propertyNames);
    }

    private PropertiesMapper getPropertiesMapper(Class<?> clazz) {
        try {
            return (PropertiesMapper)this.propertiesMapperCache.get(clazz);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static Type getActualTypeArgument(Type type, int argIndex) {
        ParameterizedType paramizedType;
        Type[] types;
        if (type instanceof ParameterizedType && (types = (paramizedType = (ParameterizedType)type).getActualTypeArguments()) != null && types.length > argIndex) {
            return types[argIndex];
        }
        return Object.class;
    }

    private static class PropertyWriter {
        private final String fieldName;
        private final java.lang.reflect.Field field;
        private final OptionalWrapper optionalWrapper;
        private Class<?> javaOptionalClass;

        public PropertyWriter(String fieldName, java.lang.reflect.Field field) {
            this.fieldName = fieldName;
            this.field = field;
            AccessController.doPrivileged(new SetFieldAccessible(field));
            this.optionalWrapper = Optional.class.isAssignableFrom(field.getType()) ? new GuavaOptionalWrapper() : (field.getType().getName().equals("java.util.Optional") ? new JavaOptionalWrapper() : new NonOptionalWrapper());
            Class<?> cl = null;
            try {
                cl = Class.forName("java.util.Optional");
            }
            catch (ClassNotFoundException | RuntimeException e) {
                // empty catch block
            }
            this.javaOptionalClass = cl;
        }

        void writeProperty(Object bean, PropertiesSource datasource) {
            Optional<Object> optionalValue = this.readValue(this.field.getType(), datasource);
            if (optionalValue == null) {
                return;
            }
            try {
                this.field.set(bean, this.optionalWrapper.unwrap(optionalValue));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }

        private Optional<Object> readValue(Class<?> clazz, PropertiesSource datasource) {
            Optional value = Optional.absent();
            Type type = this.field.getGenericType();
            if (this.isOptional(clazz)) {
                type = BeanMapper.getActualTypeArgument(type, 0);
            }
            if (ImmutableSet.class.isAssignableFrom(clazz)) {
                value = datasource.read(this.fieldName, (Class)BeanMapper.getActualTypeArgument(type, 0));
                if (value.isPresent()) {
                    return Optional.of((Object)ImmutableSet.copyOf((Collection)((Collection)value.get())));
                }
            } else if (ImmutableList.class.isAssignableFrom(clazz)) {
                value = datasource.read(this.fieldName, (Class)BeanMapper.getActualTypeArgument(type, 0));
                if (value.isPresent()) {
                    return Optional.of((Object)ImmutableList.copyOf((Collection)((Collection)value.get())));
                }
            } else if (ImmutableMap.class.isAssignableFrom(clazz)) {
                value = datasource.read(this.fieldName, (Class)BeanMapper.getActualTypeArgument(type, 0), (Class)BeanMapper.getActualTypeArgument(this.field.getGenericType(), 1));
                if (value.isPresent()) {
                    return Optional.of((Object)ImmutableMap.copyOf((Map)((Map)value.get())));
                }
            } else {
                value = datasource.read(this.fieldName, (Class)type);
            }
            return value;
        }

        private boolean isOptional(Class<?> clazz) {
            return Optional.class.isAssignableFrom(clazz) || this.javaOptionalClass != null && this.javaOptionalClass.isAssignableFrom(clazz);
        }

        private static final class JavaOptionalWrapper
        implements OptionalWrapper {
            private final Method meth;

            public JavaOptionalWrapper() {
                try {
                    this.meth = Class.forName("java.util.Optional").getDeclaredMethod("ofNullable", Object.class);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Object unwrap(Optional<Object> obj) {
                try {
                    return this.meth.invoke(null, obj.orNull());
                }
                catch (IllegalAccessException | SecurityException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private static final class NonOptionalWrapper
        implements OptionalWrapper {
            private NonOptionalWrapper() {
            }

            @Override
            public Object unwrap(Optional<Object> obj) {
                return obj.orNull();
            }
        }

        private static final class GuavaOptionalWrapper
        implements OptionalWrapper {
            private GuavaOptionalWrapper() {
            }

            @Override
            public Object unwrap(Optional<Object> obj) {
                return obj;
            }
        }

        private static interface OptionalWrapper {
            public Object unwrap(Optional<Object> var1);
        }
    }

    private static class PropertyReader {
        private final String fieldName;
        private final java.lang.reflect.Field field;
        private final OptionalWrapper optionalWrapper;

        public PropertyReader(String fieldName, java.lang.reflect.Field field) {
            this.fieldName = fieldName;
            this.field = field;
            AccessController.doPrivileged(new SetFieldAccessible(field));
            this.optionalWrapper = Optional.class.isAssignableFrom(field.getType()) ? new GuavaOptionalWrapper() : (field.getType().getName().equals("java.util.Optional") ? new JavaOptionalWrapper() : new NonOptionalWrapper());
        }

        public Map.Entry<String, Optional<Object>> readProperty(Object bean) {
            Object value = null;
            try {
                value = this.field.get(bean);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
            return Maps.immutableEntry((Object)this.fieldName, this.optionalWrapper.wrap(value));
        }

        private static final class JavaOptionalWrapper
        implements OptionalWrapper {
            private final Method meth;

            public JavaOptionalWrapper() {
                try {
                    this.meth = Class.forName("java.util.Optional").getMethod("get", new Class[0]);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Optional<Object> wrap(Object obj) {
                try {
                    return Optional.of((Object)this.meth.invoke(obj, new Object[0]));
                }
                catch (IllegalAccessException | SecurityException | InvocationTargetException e) {
                    return Optional.absent();
                }
            }
        }

        private static final class NonOptionalWrapper
        implements OptionalWrapper {
            private NonOptionalWrapper() {
            }

            @Override
            public Optional<Object> wrap(Object obj) {
                return Optional.fromNullable((Object)obj);
            }
        }

        private static final class GuavaOptionalWrapper
        implements OptionalWrapper {
            private GuavaOptionalWrapper() {
            }

            @Override
            public Optional<Object> wrap(Object obj) {
                if (obj == null) {
                    return Optional.absent();
                }
                return (Optional)obj;
            }
        }

        private static interface OptionalWrapper {
            public Optional<Object> wrap(Object var1);
        }
    }

    private static final class PropertiesMapperLoader
    extends CacheLoader<Class<?>, PropertiesMapper> {
        private PropertiesMapperLoader() {
        }

        public PropertiesMapper load(Class<?> clazz) throws Exception {
            HashMap propertyReaders = Maps.newHashMap();
            propertyReaders.putAll(PropertiesMapperLoader.fetchJEEFieldReaders((ImmutableSet<java.lang.reflect.Field>)ImmutableSet.copyOf((Object[])clazz.getFields())));
            propertyReaders.putAll(PropertiesMapperLoader.fetchJEEFieldReaders((ImmutableSet<java.lang.reflect.Field>)ImmutableSet.copyOf((Object[])clazz.getDeclaredFields())));
            propertyReaders.putAll(PropertiesMapperLoader.fetchCassandraMapperFieldReaders((ImmutableSet<java.lang.reflect.Field>)ImmutableSet.copyOf((Object[])clazz.getFields())));
            propertyReaders.putAll(PropertiesMapperLoader.fetchCassandraMapperFieldReaders((ImmutableSet<java.lang.reflect.Field>)ImmutableSet.copyOf((Object[])clazz.getDeclaredFields())));
            propertyReaders.putAll(PropertiesMapperLoader.fetchFieldReaders((ImmutableSet<java.lang.reflect.Field>)ImmutableSet.copyOf((Object[])clazz.getFields())));
            propertyReaders.putAll(PropertiesMapperLoader.fetchFieldReaders((ImmutableSet<java.lang.reflect.Field>)ImmutableSet.copyOf((Object[])clazz.getDeclaredFields())));
            HashMap propertyWriters = Maps.newHashMap();
            propertyWriters.putAll(this.fetchJEEFieldWriters((ImmutableSet<java.lang.reflect.Field>)ImmutableSet.copyOf((Object[])clazz.getFields())));
            propertyWriters.putAll(this.fetchJEEFieldWriters((ImmutableSet<java.lang.reflect.Field>)ImmutableSet.copyOf((Object[])clazz.getDeclaredFields())));
            propertyWriters.putAll(this.fetchCassandraMapperFieldWriters((ImmutableSet<java.lang.reflect.Field>)ImmutableSet.copyOf((Object[])clazz.getFields())));
            propertyWriters.putAll(this.fetchCassandraMapperFieldWriters((ImmutableSet<java.lang.reflect.Field>)ImmutableSet.copyOf((Object[])clazz.getDeclaredFields())));
            propertyWriters.putAll(this.fetchFieldWriters((ImmutableSet<java.lang.reflect.Field>)ImmutableSet.copyOf((Object[])clazz.getFields())));
            propertyWriters.putAll(this.fetchFieldWriters((ImmutableSet<java.lang.reflect.Field>)ImmutableSet.copyOf((Object[])clazz.getDeclaredFields())));
            return new PropertiesMapper((ImmutableMap<String, PropertyReader>)ImmutableMap.copyOf((Map)propertyReaders), (ImmutableMap<String, PropertyWriter>)ImmutableMap.copyOf((Map)propertyWriters), clazz);
        }

        private static ImmutableMap<String, PropertyReader> fetchFieldReaders(ImmutableSet<java.lang.reflect.Field> beanFields) {
            HashMap propertyReaders = Maps.newHashMap();
            for (java.lang.reflect.Field beanField : beanFields) {
                Field field = beanField.getAnnotation(Field.class);
                if (field == null) continue;
                propertyReaders.put(field.name(), new PropertyReader(field.name(), beanField));
            }
            return ImmutableMap.copyOf((Map)propertyReaders);
        }

        private static ImmutableMap<String, PropertyReader> fetchJEEFieldReaders(ImmutableSet<java.lang.reflect.Field> beanFields) {
            HashMap propertyReaders = Maps.newHashMap();
            for (java.lang.reflect.Field beanField : beanFields) {
                block3: for (Annotation annotation : beanField.getAnnotations()) {
                    if (!annotation.annotationType().getName().equals("javax.persistence.Column")) continue;
                    for (Method attributeMethod : annotation.annotationType().getDeclaredMethods()) {
                        if (!attributeMethod.getName().equalsIgnoreCase("name")) continue;
                        try {
                            String columnName = (String)attributeMethod.invoke((Object)annotation, new Object[0]);
                            if (columnName == null) continue block3;
                            propertyReaders.put(columnName, new PropertyReader(columnName, beanField));
                            continue block3;
                        }
                        catch (ReflectiveOperationException ignore) {
                            // empty catch block
                        }
                    }
                }
            }
            return ImmutableMap.copyOf((Map)propertyReaders);
        }

        private static ImmutableMap<String, PropertyReader> fetchCassandraMapperFieldReaders(ImmutableSet<java.lang.reflect.Field> beanFields) {
            HashMap propertyReaders = Maps.newHashMap();
            for (java.lang.reflect.Field beanField : beanFields) {
                block3: for (Annotation annotation : beanField.getAnnotations()) {
                    if (!annotation.annotationType().getName().equals("com.datastax.driver.mapping.annotations.Field")) continue;
                    for (Method attributeMethod : annotation.annotationType().getDeclaredMethods()) {
                        if (!attributeMethod.getName().equalsIgnoreCase("name")) continue;
                        try {
                            String columnName = (String)attributeMethod.invoke((Object)annotation, new Object[0]);
                            if (columnName == null) continue block3;
                            propertyReaders.put(columnName, new PropertyReader(columnName, beanField));
                            continue block3;
                        }
                        catch (ReflectiveOperationException ignore) {
                            // empty catch block
                        }
                    }
                }
            }
            return ImmutableMap.copyOf((Map)propertyReaders);
        }

        private Map<String, PropertyWriter> fetchFieldWriters(ImmutableSet<java.lang.reflect.Field> beanFields) {
            HashMap propertyWriters = Maps.newHashMap();
            for (java.lang.reflect.Field beanField : beanFields) {
                Field field = beanField.getAnnotation(Field.class);
                if (field == null) continue;
                propertyWriters.put(field.name(), new PropertyWriter(field.name(), beanField));
            }
            return ImmutableMap.copyOf((Map)propertyWriters);
        }

        private Map<String, PropertyWriter> fetchJEEFieldWriters(ImmutableSet<java.lang.reflect.Field> beanFields) {
            HashMap propertyWriters = Maps.newHashMap();
            for (java.lang.reflect.Field beanField : beanFields) {
                for (Annotation annotation : beanField.getAnnotations()) {
                    if (!annotation.annotationType().getName().equals("javax.persistence.Column")) continue;
                    for (Method attributeMethod : annotation.annotationType().getDeclaredMethods()) {
                        if (!attributeMethod.getName().equalsIgnoreCase("name")) continue;
                        try {
                            String columnName = (String)attributeMethod.invoke((Object)annotation, new Object[0]);
                            propertyWriters.put(columnName, new PropertyWriter(columnName, beanField));
                        }
                        catch (ReflectiveOperationException ignore) {
                            // empty catch block
                        }
                    }
                }
            }
            return ImmutableMap.copyOf((Map)propertyWriters);
        }

        private Map<String, PropertyWriter> fetchCassandraMapperFieldWriters(ImmutableSet<java.lang.reflect.Field> beanFields) {
            HashMap propertyWriters = Maps.newHashMap();
            for (java.lang.reflect.Field beanField : beanFields) {
                for (Annotation annotation : beanField.getAnnotations()) {
                    if (!annotation.annotationType().getName().equals("com.datastax.driver.mapping.annotations.Field")) continue;
                    for (Method attributeMethod : annotation.annotationType().getDeclaredMethods()) {
                        if (!attributeMethod.getName().equalsIgnoreCase("name")) continue;
                        try {
                            String columnName = (String)attributeMethod.invoke((Object)annotation, new Object[0]);
                            propertyWriters.put(columnName, new PropertyWriter(columnName, beanField));
                        }
                        catch (ReflectiveOperationException ignore) {
                            // empty catch block
                        }
                    }
                }
            }
            return ImmutableMap.copyOf((Map)propertyWriters);
        }
    }

    private static final class SetFieldAccessible
    implements PrivilegedAction<Object> {
        private final java.lang.reflect.Field field;

        public SetFieldAccessible(java.lang.reflect.Field field) {
            this.field = field;
        }

        @Override
        public Object run() {
            this.field.setAccessible(true);
            return null;
        }
    }

    private static final class SetConstructorAccessible<T>
    implements PrivilegedAction<Object> {
        private final Constructor<T> constructor;

        public SetConstructorAccessible(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        @Override
        public Object run() {
            this.constructor.setAccessible(true);
            return null;
        }
    }

    private static final class PropertiesMapper {
        private final Class<?> clazz;
        private final ImmutableMap<String, PropertyWriter> propertyWriters;
        private final ImmutableMap<String, PropertyReader> propertyReaders;

        public PropertiesMapper(ImmutableMap<String, PropertyReader> propertyReaders, ImmutableMap<String, PropertyWriter> propertyWriters, Class<?> clazz) {
            this.propertyReaders = propertyReaders;
            this.propertyWriters = propertyWriters;
            this.clazz = clazz;
        }

        public ImmutableMap<String, Optional<Object>> toValues(Object entity, ImmutableSet<String> namesToMap) {
            HashMap values = Maps.newHashMap();
            for (Map.Entry entry : this.propertyReaders.entrySet()) {
                if (!namesToMap.isEmpty() && !namesToMap.contains(entry.getKey())) continue;
                Map.Entry<String, Optional<Object>> pair = ((PropertyReader)entry.getValue()).readProperty(entity);
                values.put(pair.getKey(), pair.getValue());
            }
            return ImmutableMap.copyOf((Map)values);
        }

        public <T> T fromValues(PropertiesSource datasource, ImmutableSet<String> namesToMap) {
            try {
                Object bean = this.newInstance(this.clazz.getDeclaredConstructor(new Class[0]));
                for (Map.Entry entry : this.propertyWriters.entrySet()) {
                    if (!namesToMap.isEmpty() && !namesToMap.contains(entry.getKey())) continue;
                    ((PropertyWriter)entry.getValue()).writeProperty(bean, datasource);
                }
                return (T)bean;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        private <T> T newInstance(Constructor<T> constructor) {
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                AccessController.doPrivileged(new SetConstructorAccessible<T>(constructor));
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e2) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

