/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.TupleValue;
import com.google.common.base.Optional;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.oneandone.troilus.PropertiesSource;

public abstract class ColumnName<T> {
    private final String name;

    private ColumnName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    abstract Optional<T> read(PropertiesSource var1);

    public static <E> ColumnName<E> define(String name, Class<E> type) {
        return new SkalarName<E>(name, type);
    }

    public static <E> ColumnName<List<E>> defineList(String name, Class<E> elementType) {
        return new ListName(name, elementType);
    }

    public static <E> ColumnName<Set<E>> defineSet(String name, Class<E> elementType) {
        return new SetName(name, elementType);
    }

    public static <E, F> ColumnName<Map<E, F>> defineMap(String name, Class<E> keyType, Class<F> valueType) {
        return new MapName(name, keyType, valueType);
    }

    public static ColumnName<Long> defineLong(String name) {
        return ColumnName.define(name, Long.class);
    }

    public static ColumnName<String> defineString(String name) {
        return ColumnName.define(name, String.class);
    }

    public static ColumnName<Boolean> defineBool(String name) {
        return ColumnName.define(name, Boolean.class);
    }

    public static ColumnName<ByteBuffer> defineByteBuffer(String name) {
        return ColumnName.define(name, ByteBuffer.class);
    }

    public static ColumnName<Float> defineFloat(String name) {
        return ColumnName.define(name, Float.class);
    }

    public static ColumnName<Date> defineDate(String name) {
        return ColumnName.define(name, Date.class);
    }

    public static ColumnName<BigDecimal> defineDecimal(String name) {
        return ColumnName.define(name, BigDecimal.class);
    }

    public static ColumnName<Integer> defineInt(String name) {
        return ColumnName.define(name, Integer.class);
    }

    public static ColumnName<InetAddress> defineInet(String name) {
        return ColumnName.define(name, InetAddress.class);
    }

    public static ColumnName<BigInteger> defineVarint(String name) {
        return ColumnName.define(name, BigInteger.class);
    }

    public static ColumnName<TupleValue> defineTupleValue(String name) {
        return ColumnName.define(name, TupleValue.class);
    }

    public static ColumnName<UUID> defineUUID(String name) {
        return ColumnName.define(name, UUID.class);
    }

    public static ColumnName<byte[]> defineBytes(String name) {
        return ColumnName.define(name, byte[].class);
    }

    private static class MapName<T, V>
    extends ColumnName<Map<T, V>> {
        private final Class<T> keyType;
        private final Class<V> valueType;

        private MapName(String name, Class<T> keyType, Class<V> valueType) {
            super(name);
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        Optional<Map<T, V>> read(PropertiesSource propertiesSource) {
            return propertiesSource.read(this.getName(), this.keyType, this.valueType);
        }
    }

    private static class SetName<T>
    extends ColumnName<Set<T>> {
        private final Class<T> elementType;

        private SetName(String name, Class<T> elementType) {
            super(name);
            this.elementType = elementType;
        }

        @Override
        Optional<Set<T>> read(PropertiesSource propertiesSource) {
            return propertiesSource.read(this.getName(), this.elementType);
        }
    }

    private static class ListName<T>
    extends ColumnName<List<T>> {
        private final Class<T> elementType;

        private ListName(String name, Class<T> elementType) {
            super(name);
            this.elementType = elementType;
        }

        @Override
        Optional<List<T>> read(PropertiesSource propertiesSource) {
            return propertiesSource.read(this.getName(), this.elementType);
        }
    }

    private static class SkalarName<T>
    extends ColumnName<T> {
        private final Class<T> type;

        SkalarName(String name, Class<T> type) {
            super(name);
            this.type = type;
        }

        @Override
        Optional<T> read(PropertiesSource propertiesSource) {
            return propertiesSource.read(this.getName(), this.type);
        }
    }
}

