/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import net.oneandone.troilus.BeanMapper;
import net.oneandone.troilus.InterceptorRegistry;
import net.oneandone.troilus.UDTValueMapper;
import net.oneandone.troilus.interceptor.QueryInterceptor;

class Context {
    private final ExecutionSpec executionSpec;
    private final InterceptorRegistry interceptorRegistry;
    private final BeanMapper beanMapper;
    private final Executor executors;
    private final DBSession dbSession;

    Context(Session session, String tablename) {
        this(session, tablename, new BeanMapper());
    }

    private Context(Session session, String tablename, BeanMapper beanMapper) {
        this(new DBSession(session, tablename, beanMapper), new ExecutionSpec(), new InterceptorRegistry(), beanMapper, Context.newTaskExecutor());
    }

    private static Executor newTaskExecutor() {
        try {
            Method commonPoolMeth = ForkJoinPool.class.getMethod("commonPool", new Class[0]);
            return (Executor)commonPoolMeth.invoke(ForkJoinPool.class, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return Executors.newCachedThreadPool();
        }
    }

    private Context(DBSession dbSession, ExecutionSpec executionSpec, InterceptorRegistry interceptorRegistry, BeanMapper beanMapper, Executor executors) {
        this.dbSession = dbSession;
        this.executionSpec = executionSpec;
        this.interceptorRegistry = interceptorRegistry;
        this.executors = executors;
        this.beanMapper = beanMapper;
    }

    Context withInterceptor(QueryInterceptor interceptor) {
        return new Context(this.dbSession, this.executionSpec, this.interceptorRegistry.withInterceptor(interceptor), this.beanMapper, this.executors);
    }

    Context withSerialConsistency(ConsistencyLevel consistencyLevel) {
        return new Context(this.dbSession, this.executionSpec.withSerialConsistency(consistencyLevel), this.interceptorRegistry, this.beanMapper, this.executors);
    }

    Context withTtl(int ttlSec) {
        return new Context(this.dbSession, this.executionSpec.withTtl(ttlSec), this.interceptorRegistry, this.beanMapper, this.executors);
    }

    Context withWritetime(long microsSinceEpoch) {
        return new Context(this.dbSession, this.executionSpec.withWritetime(microsSinceEpoch), this.interceptorRegistry, this.beanMapper, this.executors);
    }

    Context withEnableTracking() {
        return new Context(this.dbSession, this.executionSpec.withEnableTracking(), this.interceptorRegistry, this.beanMapper, this.executors);
    }

    Context withDisableTracking() {
        return new Context(this.dbSession, this.executionSpec.withDisableTracking(), this.interceptorRegistry, this.beanMapper, this.executors);
    }

    Context withRetryPolicy(RetryPolicy policy) {
        return new Context(this.dbSession, this.executionSpec.withRetryPolicy(policy), this.interceptorRegistry, this.beanMapper, this.executors);
    }

    Context withConsistency(ConsistencyLevel consistencyLevel) {
        return new Context(this.dbSession, this.executionSpec.withConsistency(consistencyLevel), this.interceptorRegistry, this.beanMapper, this.executors);
    }

    ConsistencyLevel getConsistencyLevel() {
        return this.executionSpec.getConsistencyLevel();
    }

    ConsistencyLevel getSerialConsistencyLevel() {
        return this.executionSpec.getSerialConsistencyLevel();
    }

    Integer getTtlSec() {
        return this.executionSpec.getTtl();
    }

    Long getWritetime() {
        return this.executionSpec.getWritetime();
    }

    Boolean getEnableTracing() {
        return this.executionSpec.getEnableTracing();
    }

    DBSession getDbSession() {
        return this.dbSession;
    }

    RetryPolicy getRetryPolicy() {
        return this.executionSpec.getRetryPolicy();
    }

    Executor getTaskExecutor() {
        return this.executors;
    }

    BeanMapper getBeanMapper() {
        return this.beanMapper;
    }

    InterceptorRegistry getInterceptorRegistry() {
        return this.interceptorRegistry;
    }

    ImmutableList<Object> toStatementValues(String name, ImmutableList<Object> values) {
        ArrayList result = Lists.newArrayList();
        for (Object value : values) {
            result.add(this.toStatementValue(name, value));
        }
        return ImmutableList.copyOf((Collection)result);
    }

    Object toStatementValue(String name, Object value) {
        if (this.isNullOrEmpty(value)) {
            return null;
        }
        DataType dataType = this.dbSession.getColumnMetadata(name).getType();
        if (UDTValueMapper.isBuildInType(dataType)) {
            if (this.isTextDataType(dataType) && Enum.class.isAssignableFrom(value.getClass())) {
                return value.toString();
            }
            if (dataType.equals(DataType.blob()) && byte[].class.isAssignableFrom(value.getClass())) {
                return ByteBuffer.wrap((byte[])value);
            }
            return value;
        }
        return this.dbSession.getUDTValueMapper().toUdtValue(this.dbSession.getUserTypeCache(), this.dbSession.getColumnMetadata(name).getType(), value);
    }

    boolean isTextDataType(DataType dataType) {
        return dataType.equals(DataType.text()) || dataType.equals(DataType.ascii()) || dataType.equals(DataType.varchar());
    }

    private boolean isNullOrEmpty(Object value) {
        return value == null || Collection.class.isAssignableFrom(value.getClass()) && ((Collection)value).isEmpty() || Map.class.isAssignableFrom(value.getClass()) && ((Map)value).isEmpty();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dsession", (Object)this.dbSession).add("execution-spec", (Object)this.executionSpec).add("interceptorRegistry", (Object)this.interceptorRegistry).toString();
    }

    static class DBSession {
        private final Session session;
        private final String tablename;
        private final TableMetadata tableMetadata;
        private final ImmutableSet<String> columnNames;
        private final UDTValueMapper udtValueMapper;
        private final Cache<String, PreparedStatement> preparedStatementsCache;
        private final LoadingCache<String, UserType> userTypeCache;

        public DBSession(Session session, String tablename, BeanMapper beanMapper) {
            this.session = session;
            this.tablename = tablename;
            this.tableMetadata = DBSession.loadTableMetadata(session, tablename);
            this.columnNames = DBSession.loadColumnNames(this.tableMetadata);
            this.udtValueMapper = new UDTValueMapper(session.getCluster().getConfiguration().getProtocolOptions().getProtocolVersionEnum(), beanMapper);
            this.preparedStatementsCache = CacheBuilder.newBuilder().maximumSize(150L).build();
            this.userTypeCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new UserTypeCacheLoader(session));
        }

        private static TableMetadata loadTableMetadata(Session session, String tablename) {
            TableMetadata tableMetadata = session.getCluster().getMetadata().getKeyspace(session.getLoggedKeyspace()).getTable(tablename);
            if (tableMetadata == null) {
                throw new RuntimeException("table " + session.getLoggedKeyspace() + "." + tablename + " is not defined in keyspace '" + session.getLoggedKeyspace() + "'");
            }
            return tableMetadata;
        }

        private static ImmutableSet<String> loadColumnNames(TableMetadata tableMetadata) {
            HashSet columnNames = Sets.newHashSet();
            for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
                columnNames.add(columnMetadata.getName());
            }
            return ImmutableSet.copyOf((Collection)columnNames);
        }

        Session getSession() {
            return this.session;
        }

        String getTablename() {
            return this.tablename;
        }

        ProtocolVersion getProtocolVersion() {
            return this.getSession().getCluster().getConfiguration().getProtocolOptions().getProtocolVersionEnum();
        }

        LoadingCache<String, UserType> getUserTypeCache() {
            return this.userTypeCache;
        }

        UDTValueMapper getUDTValueMapper() {
            return this.udtValueMapper;
        }

        ImmutableSet<String> getColumnNames() {
            return this.columnNames;
        }

        ColumnMetadata getColumnMetadata(String columnName) {
            ColumnMetadata metadata = this.tableMetadata.getColumn(columnName);
            if (metadata == null) {
                throw new RuntimeException("table " + this.session.getLoggedKeyspace() + "." + this.tablename + " does not support column '" + columnName + "'");
            }
            return metadata;
        }

        PreparedStatement prepare(BuiltStatement statement) {
            PreparedStatement preparedStatment = (PreparedStatement)this.preparedStatementsCache.getIfPresent((Object)statement.getQueryString());
            if (preparedStatment == null) {
                preparedStatment = this.session.prepare((RegularStatement)statement);
                this.preparedStatementsCache.put((Object)statement.getQueryString(), (Object)preparedStatment);
            }
            return preparedStatment;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("tablename", (Object)this.tablename).add("preparedStatementsCache", (Object)this.printCache(this.preparedStatementsCache)).toString();
        }

        private String printCache(Cache<String, ?> cache) {
            return Joiner.on((String)", ").withKeyValueSeparator("=").join((Map)cache.asMap());
        }

        private static final class UserTypeCacheLoader
        extends CacheLoader<String, UserType> {
            private final Session session;

            public UserTypeCacheLoader(Session session) {
                this.session = session;
            }

            public UserType load(String usertypeName) throws Exception {
                return this.session.getCluster().getMetadata().getKeyspace(this.session.getLoggedKeyspace()).getUserType(usertypeName);
            }
        }
    }

    static class ExecutionSpec {
        private final ConsistencyLevel consistencyLevel;
        private final ConsistencyLevel serialConsistencyLevel;
        private final Integer ttlSec;
        private final Long writetimeMicrosSinceEpoch;
        private final Boolean enableTracing;
        private final RetryPolicy retryPolicy;

        ExecutionSpec() {
            this(null, null, null, null, null, null);
        }

        public ExecutionSpec(ConsistencyLevel consistencyLevel, ConsistencyLevel serialConsistencyLevel, Integer ttlSec, Long writetimeMicrosSinceEpoch, Boolean enableTracking, RetryPolicy retryPolicy) {
            this.consistencyLevel = consistencyLevel;
            this.serialConsistencyLevel = serialConsistencyLevel;
            this.ttlSec = ttlSec;
            this.writetimeMicrosSinceEpoch = writetimeMicrosSinceEpoch;
            this.enableTracing = enableTracking;
            this.retryPolicy = retryPolicy;
        }

        ExecutionSpec withConsistency(ConsistencyLevel consistencyLevel) {
            return new ExecutionSpec(consistencyLevel, this.serialConsistencyLevel, this.ttlSec, this.writetimeMicrosSinceEpoch, this.enableTracing, this.retryPolicy);
        }

        ExecutionSpec withSerialConsistency(ConsistencyLevel consistencyLevel) {
            return new ExecutionSpec(this.consistencyLevel, consistencyLevel, this.ttlSec, this.writetimeMicrosSinceEpoch, this.enableTracing, this.retryPolicy);
        }

        ExecutionSpec withTtl(int ttlSec) {
            return new ExecutionSpec(this.consistencyLevel, this.serialConsistencyLevel, ttlSec, this.writetimeMicrosSinceEpoch, this.enableTracing, this.retryPolicy);
        }

        ExecutionSpec withWritetime(long microsSinceEpoch) {
            return new ExecutionSpec(this.consistencyLevel, this.serialConsistencyLevel, this.ttlSec, microsSinceEpoch, this.enableTracing, this.retryPolicy);
        }

        ExecutionSpec withEnableTracking() {
            return new ExecutionSpec(this.consistencyLevel, this.serialConsistencyLevel, this.ttlSec, this.writetimeMicrosSinceEpoch, true, this.retryPolicy);
        }

        ExecutionSpec withDisableTracking() {
            return new ExecutionSpec(this.consistencyLevel, this.serialConsistencyLevel, this.ttlSec, this.writetimeMicrosSinceEpoch, false, this.retryPolicy);
        }

        ExecutionSpec withRetryPolicy(RetryPolicy policy) {
            return new ExecutionSpec(this.consistencyLevel, this.serialConsistencyLevel, this.ttlSec, this.writetimeMicrosSinceEpoch, this.enableTracing, policy);
        }

        public ConsistencyLevel getConsistencyLevel() {
            return this.consistencyLevel;
        }

        public ConsistencyLevel getSerialConsistencyLevel() {
            return this.serialConsistencyLevel;
        }

        public Integer getTtl() {
            return this.ttlSec;
        }

        public Long getWritetime() {
            return this.writetimeMicrosSinceEpoch;
        }

        public Boolean getEnableTracing() {
            return this.enableTracing;
        }

        public RetryPolicy getRetryPolicy() {
            return this.retryPolicy;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"spec").add("consistencyLevel", (Object)this.consistencyLevel).add("serialConsistencyLevel", (Object)this.serialConsistencyLevel).add("ttlSec", (Object)this.ttlSec).add("writetimeMicrosSinceEpoch", (Object)this.writetimeMicrosSinceEpoch).add("enableTracing", (Object)this.enableTracing).add("retryPolicy", (Object)this.retryPolicy).toString();
        }
    }
}

