/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.oneandone.troilus.Result;

public abstract class Count
implements Result {
    public abstract long getCount();

    static Count newCountResult(ResultSet rs) {
        return new CountResultImpl(rs);
    }

    private static final class CountResultImpl
    extends Count {
        private final ResultSet rs;
        private final long count;

        private CountResultImpl(ResultSet rs) {
            this.rs = rs;
            this.count = rs.one().getLong("count");
        }

        @Override
        public ExecutionInfo getExecutionInfo() {
            return this.rs.getExecutionInfo();
        }

        @Override
        public ImmutableList<ExecutionInfo> getAllExecutionInfo() {
            return ImmutableList.copyOf((Collection)this.rs.getAllExecutionInfo());
        }

        @Override
        public boolean wasApplied() {
            return this.rs.wasApplied();
        }

        @Override
        public long getCount() {
            return this.count;
        }
    }
}

