/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import net.oneandone.troilus.AbstractQuery;
import net.oneandone.troilus.BatchQueryFutureAdapter;
import net.oneandone.troilus.Context;
import net.oneandone.troilus.CounterBatchable;
import net.oneandone.troilus.Immutables;
import net.oneandone.troilus.ListenableFutures;
import net.oneandone.troilus.Result;
import net.oneandone.troilus.java7.CounterBatchMutation;

class CounterBatchMutationQuery
extends AbstractQuery<CounterBatchMutation>
implements CounterBatchMutation {
    private final ImmutableList<CounterBatchable> batchables;

    CounterBatchMutationQuery(Context ctx, ImmutableList<CounterBatchable> batchables) {
        super(ctx);
        this.batchables = batchables;
    }

    @Override
    protected CounterBatchMutationQuery newQuery(Context newContext) {
        return new CounterBatchMutationQuery(newContext, this.batchables);
    }

    @Override
    public CounterBatchMutationQuery combinedWith(CounterBatchable other) {
        return new CounterBatchMutationQuery(this.getContext(), Immutables.merge(this.batchables, other));
    }

    private ListenableFuture<Statement> getStatementAsync() {
        return new BatchQueryFutureAdapter(new BatchStatement(BatchStatement.Type.COUNTER), this.batchables.iterator());
    }

    @Override
    public Result execute() {
        return ListenableFutures.getUninterruptibly(this.executeAsync());
    }

    @Override
    public ListenableFuture<Result> executeAsync() {
        ListenableFuture<ResultSet> future = this.performAsync(this.getStatementAsync());
        Function<ResultSet, Result> mapEntity = new Function<ResultSet, Result>(){

            public Result apply(ResultSet resultSet) {
                return CounterBatchMutationQuery.this.newResult(resultSet);
            }
        };
        return Futures.transform(future, (Function)mapEntity);
    }
}

