/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Update;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Map;
import net.oneandone.troilus.Context;

class CounterMutationQueryData {
    private final ImmutableMap<String, Object> keys;
    private final ImmutableList<Clause> whereConditions;
    private final String name;
    private final long diff;

    public CounterMutationQueryData() {
        this((ImmutableMap<String, Object>)ImmutableMap.of(), (ImmutableList<Clause>)ImmutableList.of(), null, 0L);
    }

    private CounterMutationQueryData(ImmutableMap<String, Object> keys, ImmutableList<Clause> whereConditions, String name, long diff) {
        this.keys = keys;
        this.whereConditions = whereConditions;
        this.name = name;
        this.diff = diff;
    }

    public CounterMutationQueryData keys(ImmutableMap<String, Object> keys) {
        return new CounterMutationQueryData(keys, this.whereConditions, this.name, this.diff);
    }

    public CounterMutationQueryData whereConditions(ImmutableList<Clause> whereConditions) {
        return new CounterMutationQueryData(this.keys, whereConditions, this.name, this.diff);
    }

    public CounterMutationQueryData name(String name) {
        return new CounterMutationQueryData(this.keys, this.whereConditions, name, this.diff);
    }

    public CounterMutationQueryData diff(long diff) {
        return new CounterMutationQueryData(this.keys, this.whereConditions, this.name, diff);
    }

    public ImmutableMap<String, Object> getKeys() {
        return this.keys;
    }

    public ImmutableList<Clause> getWhereConditions() {
        return this.whereConditions;
    }

    public String getName() {
        return this.name;
    }

    public long getDiff() {
        return this.diff;
    }

    ListenableFuture<Statement> toStatementAsync(Context ctx) {
        Update update = QueryBuilder.update((String)ctx.getDbSession().getTablename());
        if (this.getWhereConditions().isEmpty()) {
            ArrayList values = Lists.newArrayList();
            if (this.getDiff() > 0L) {
                update.with(QueryBuilder.incr((String)this.getName(), (BindMarker)QueryBuilder.bindMarker()));
                values.add(this.getDiff());
            } else {
                update.with(QueryBuilder.decr((String)this.getName(), (BindMarker)QueryBuilder.bindMarker()));
                values.add(0L - this.getDiff());
            }
            for (Map.Entry entry : this.getKeys().entrySet()) {
                update.where(QueryBuilder.eq((String)((String)entry.getKey()), (Object)QueryBuilder.bindMarker()));
                values.add(entry.getValue());
            }
            if (ctx.getTtlSec() != null) {
                update.using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker()));
                values.add(ctx.getTtlSec());
            }
            return Futures.immediateFuture((Object)ctx.getDbSession().prepare((BuiltStatement)update).bind(values.toArray()));
        }
        if (this.getDiff() > 0L) {
            update.with(QueryBuilder.incr((String)this.getName(), (long)this.getDiff()));
        } else {
            update.with(QueryBuilder.decr((String)this.getName(), (long)(0L - this.getDiff())));
        }
        if (ctx.getTtlSec() != null) {
            update.using(QueryBuilder.ttl((int)ctx.getTtlSec()));
        }
        for (Clause whereCondition : this.getWhereConditions()) {
            update.where(whereCondition);
        }
        return Futures.immediateFuture((Object)update);
    }
}

