/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Clause;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import net.oneandone.troilus.Context;
import net.oneandone.troilus.DeleteQueryDataImpl;
import net.oneandone.troilus.IfConditionException;
import net.oneandone.troilus.ListenableFutures;
import net.oneandone.troilus.MutationQuery;
import net.oneandone.troilus.Result;
import net.oneandone.troilus.interceptor.DeleteQueryData;
import net.oneandone.troilus.java7.Deletion;
import net.oneandone.troilus.java7.interceptor.DeleteQueryRequestInterceptor;

class DeleteQuery
extends MutationQuery<Deletion>
implements Deletion {
    private final DeleteQueryData data;

    DeleteQuery(Context ctx, DeleteQueryData data) {
        super(ctx);
        this.data = data;
    }

    public Deletion withTtl(int ttlSec) {
        return this.newQuery(this.getContext().withTtl(ttlSec));
    }

    @Override
    protected DeleteQuery newQuery(Context newContext) {
        return new DeleteQuery(newContext, this.data);
    }

    public DeleteQuery onlyIf(Clause ... onlyIfConditions) {
        return new DeleteQuery(this.getContext(), this.data.onlyIfConditions((ImmutableList<Clause>)ImmutableList.copyOf((Object[])onlyIfConditions)));
    }

    public DeleteQuery ifExists() {
        return new DeleteQuery(this.getContext(), this.data.ifExists(true));
    }

    @Override
    public ListenableFuture<Result> executeAsync() {
        ListenableFuture<ResultSet> future = this.performAsync(this.getStatementAsync());
        Function<ResultSet, Result> mapResult = new Function<ResultSet, Result>(){

            public Result apply(ResultSet resultSet) {
                if (resultSet == null) {
                    throw new NullPointerException();
                }
                Result result = DeleteQuery.this.newResult(resultSet);
                if (!DeleteQuery.this.data.getOnlyIfConditions().isEmpty() && !result.wasApplied()) {
                    throw new IfConditionException(result, "if condition does not match");
                }
                return result;
            }
        };
        return Futures.transform(future, (Function)mapResult);
    }

    @Override
    public ListenableFuture<Statement> getStatementAsync() {
        ListenableFuture<DeleteQueryData> queryDataFuture = this.executeRequestInterceptorsAsync((ListenableFuture<DeleteQueryData>)Futures.immediateFuture((Object)this.data));
        Function<DeleteQueryData, Statement> queryDataToStatement = new Function<DeleteQueryData, Statement>(){

            public Statement apply(DeleteQueryData queryData) {
                if (queryData == null) {
                    throw new NullPointerException();
                }
                return DeleteQueryDataImpl.toStatement(queryData, DeleteQuery.this.getContext());
            }
        };
        return Futures.transform(queryDataFuture, (Function)queryDataToStatement);
    }

    private ListenableFuture<DeleteQueryData> executeRequestInterceptorsAsync(ListenableFuture<DeleteQueryData> queryDataFuture) {
        UnmodifiableIterator unmodifiableIterator = this.getContext().getInterceptorRegistry().getInterceptors(DeleteQueryRequestInterceptor.class).reverse().iterator();
        while (unmodifiableIterator.hasNext()) {
            DeleteQueryRequestInterceptor interceptor;
            final DeleteQueryRequestInterceptor icptor = interceptor = (DeleteQueryRequestInterceptor)unmodifiableIterator.next();
            Function<DeleteQueryData, ListenableFuture<DeleteQueryData>> mapperFunction = new Function<DeleteQueryData, ListenableFuture<DeleteQueryData>>(){

                public ListenableFuture<DeleteQueryData> apply(DeleteQueryData queryData) {
                    return icptor.onDeleteRequestAsync(queryData);
                }
            };
            queryDataFuture = ListenableFutures.transform(queryDataFuture, mapperFunction, this.getContext().getTaskExecutor());
        }
        return queryDataFuture;
    }
}

