/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import net.oneandone.troilus.Context;
import net.oneandone.troilus.interceptor.DeleteQueryData;

class DeleteQueryDataImpl
implements DeleteQueryData {
    private final ImmutableMap<String, Object> keyNameValuePairs;
    private final ImmutableList<Clause> whereConditions;
    private final ImmutableList<Clause> onlyIfConditions;
    private final Boolean ifExists;

    DeleteQueryDataImpl() {
        this((ImmutableMap<String, Object>)ImmutableMap.of(), (ImmutableList<Clause>)ImmutableList.of(), (ImmutableList<Clause>)ImmutableList.of(), null);
    }

    private DeleteQueryDataImpl(ImmutableMap<String, Object> keyNameValuePairs, ImmutableList<Clause> whereConditions, ImmutableList<Clause> onlyIfConditions, Boolean ifExists) {
        this.keyNameValuePairs = keyNameValuePairs;
        this.whereConditions = whereConditions;
        this.onlyIfConditions = onlyIfConditions;
        this.ifExists = ifExists;
    }

    @Override
    public DeleteQueryDataImpl keys(ImmutableMap<String, Object> keyNameValuePairs) {
        return new DeleteQueryDataImpl(keyNameValuePairs, this.whereConditions, this.onlyIfConditions, this.ifExists);
    }

    @Override
    public DeleteQueryDataImpl whereConditions(ImmutableList<Clause> whereConditions) {
        return new DeleteQueryDataImpl(this.keyNameValuePairs, whereConditions, this.onlyIfConditions, this.ifExists);
    }

    @Override
    public DeleteQueryDataImpl onlyIfConditions(ImmutableList<Clause> onlyIfConditions) {
        return new DeleteQueryDataImpl(this.keyNameValuePairs, this.whereConditions, onlyIfConditions, this.ifExists);
    }

    @Override
    public DeleteQueryDataImpl ifExists(Boolean ifExists) {
        return new DeleteQueryDataImpl(this.keyNameValuePairs, this.whereConditions, this.onlyIfConditions, ifExists);
    }

    @Override
    public ImmutableMap<String, Object> getKeys() {
        return this.keyNameValuePairs;
    }

    @Override
    public ImmutableList<Clause> getWhereConditions() {
        return this.whereConditions;
    }

    @Override
    public ImmutableList<Clause> getOnlyIfConditions() {
        return this.onlyIfConditions;
    }

    @Override
    public Boolean getIfExists() {
        return this.ifExists;
    }

    static Statement toStatement(DeleteQueryData data, Context ctx) {
        Delete delete = QueryBuilder.delete().from(ctx.getDbSession().getTablename());
        for (Clause onlyIfCondition : data.getOnlyIfConditions()) {
            delete.onlyIf(onlyIfCondition);
        }
        if (data.getIfExists() != null && data.getIfExists().booleanValue()) {
            delete.ifExists();
        }
        if (data.getWhereConditions().isEmpty()) {
            ArrayList values = Lists.newArrayList();
            for (Map.Entry entry : data.getKeys().entrySet()) {
                Clause keybasedWhereClause = QueryBuilder.eq((String)((String)entry.getKey()), (Object)QueryBuilder.bindMarker());
                delete.where(keybasedWhereClause);
                values.add(ctx.toStatementValue((String)entry.getKey(), entry.getValue()));
            }
            return ctx.getDbSession().prepare((BuiltStatement)delete).bind(values.toArray());
        }
        for (Clause whereCondition : data.getWhereConditions()) {
            delete.where(whereCondition);
        }
        return delete;
    }
}

