/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

class Immutables {
    Immutables() {
    }

    public static <T> ImmutableSet<T> merge(ImmutableSet<T> set, T entryToAdd) {
        return ImmutableSet.builder().addAll(set).add(entryToAdd).build();
    }

    public static <T> ImmutableSet<T> merge(ImmutableSet<T> set1, ImmutableSet<T> set2) {
        return ImmutableSet.builder().addAll(set1).addAll(set2).build();
    }

    public static <T> ImmutableList<T> merge(ImmutableList<T> list, T entryToAdd) {
        return ImmutableList.builder().addAll(list).add(entryToAdd).build();
    }

    public static <T> ImmutableList<T> merge(ImmutableList<T> list1, ImmutableList<T> list2) {
        return ImmutableList.builder().addAll(list1).addAll(list2).build();
    }

    public static <K, V> ImmutableMap<K, V> merge(ImmutableMap<K, V> map, K key, V value) {
        HashMap m = Maps.newHashMap(map);
        m.put(key, value);
        return ImmutableMap.copyOf((Map)m);
    }

    public static <K, V> ImmutableMap<K, V> merge(ImmutableMap<K, V> map1, ImmutableMap<K, V> map2) {
        return ImmutableMap.builder().putAll(map1).putAll(map2).build();
    }
}

