/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import net.oneandone.troilus.Immutables;
import net.oneandone.troilus.interceptor.QueryInterceptor;

class InterceptorRegistry {
    private final ImmutableList<QueryInterceptor> interceptors;
    private final LoadingCache<Class<? extends QueryInterceptor>, ImmutableList<QueryInterceptor>> interceptorsByTypeCache = CacheBuilder.newBuilder().build((CacheLoader)new InterceptorsByTypeLoader());

    public InterceptorRegistry() {
        this((ImmutableList<QueryInterceptor>)ImmutableList.of());
    }

    private InterceptorRegistry(ImmutableList<QueryInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    <T extends QueryInterceptor> InterceptorRegistry withInterceptor(T interceptor) {
        return new InterceptorRegistry(Immutables.merge(this.interceptors, interceptor));
    }

    public <T extends QueryInterceptor> ImmutableList<T> getInterceptors(Class<T> clazz) {
        try {
            return (ImmutableList)this.interceptorsByTypeCache.get(clazz);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"interceptorregistry").add("interceptors", (Object)Joiner.on((String)",").join(this.interceptors)).toString();
    }

    private final class InterceptorsByTypeLoader
    extends CacheLoader<Class<?>, ImmutableList<QueryInterceptor>> {
        private InterceptorsByTypeLoader() {
        }

        public ImmutableList<QueryInterceptor> load(Class<?> clazz) throws Exception {
            ArrayList result = Lists.newArrayList();
            for (QueryInterceptor interceptor : InterceptorRegistry.this.interceptors) {
                if (!clazz.isAssignableFrom(interceptor.getClass())) continue;
                result.add(interceptor);
            }
            return ImmutableList.copyOf((Collection)result);
        }
    }
}

