/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.oneandone.troilus.AbstractQuery;
import net.oneandone.troilus.ColumnName;
import net.oneandone.troilus.Context;
import net.oneandone.troilus.Count;
import net.oneandone.troilus.EntityList;
import net.oneandone.troilus.Immutables;
import net.oneandone.troilus.ListReadQueryDataImpl;
import net.oneandone.troilus.ListenableFutures;
import net.oneandone.troilus.RecordImpl;
import net.oneandone.troilus.java7.ListRead;
import net.oneandone.troilus.java7.ListReadWithUnit;
import net.oneandone.troilus.java7.Record;
import net.oneandone.troilus.java7.RecordList;
import net.oneandone.troilus.java7.interceptor.ListReadQueryData;
import net.oneandone.troilus.java7.interceptor.ListReadQueryRequestInterceptor;
import net.oneandone.troilus.java7.interceptor.ListReadQueryResponseInterceptor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ListReadQuery
extends AbstractQuery<ListReadQuery>
implements ListReadWithUnit<RecordList> {
    final ListReadQueryDataImpl data;

    ListReadQuery(Context ctx, ListReadQueryDataImpl data) {
        super(ctx);
        this.data = data;
    }

    @Override
    protected ListReadQuery newQuery(Context newContext) {
        return new ListReadQuery(newContext, this.data);
    }

    public ListReadQuery all() {
        return new ListReadQuery(this.getContext(), (ListReadQueryDataImpl)this.data.columnsToFetch(ImmutableMap.of()));
    }

    private ListReadQuery columns(ImmutableCollection<String> namesToRead) {
        ListReadQuery read = this;
        for (String columnName : namesToRead) {
            read = read.column(columnName);
        }
        return read;
    }

    public ListReadQuery column(String name) {
        return new ListReadQuery(this.getContext(), (ListReadQueryDataImpl)this.data.columnsToFetch((ImmutableMap)Immutables.merge(this.data.getColumnsToFetch(), name, false)));
    }

    public ListReadQuery columnWithMetadata(String name) {
        return new ListReadQuery(this.getContext(), (ListReadQueryDataImpl)this.data.columnsToFetch((ImmutableMap)Immutables.merge(this.data.getColumnsToFetch(), name, true)));
    }

    public ListReadQuery columns(String ... names) {
        return this.columns((ImmutableCollection<String>)ImmutableSet.copyOf((Object[])names));
    }

    public ListReadQuery column(ColumnName<?> name) {
        return this.column(name.getName());
    }

    public ListReadQuery columnWithMetadata(ColumnName<?> name) {
        return this.columnWithMetadata(name.getName());
    }

    public ListReadQuery columns(ColumnName<?> ... names) {
        ArrayList ns = Lists.newArrayList();
        for (ColumnName<?> name : names) {
            ns.add(name.getName());
        }
        return this.columns((ImmutableCollection<String>)ImmutableList.copyOf((Collection)ns));
    }

    public ListReadQuery withLimit(int limit) {
        return new ListReadQuery(this.getContext(), this.data.limit(limit));
    }

    public ListReadQuery withAllowFiltering() {
        return new ListReadQuery(this.getContext(), this.data.allowFiltering(true));
    }

    public ListReadQuery withFetchSize(int fetchSize) {
        return new ListReadQuery(this.getContext(), this.data.fetchSize(fetchSize));
    }

    public ListReadQuery withDistinct() {
        return new ListReadQuery(this.getContext(), this.data.distinct(true));
    }

    public CountReadQuery count() {
        return new CountReadQuery(this.getContext(), new CountReadQueryData().whereConditions(this.data.getWhereConditions()).limit(this.data.getLimit()).fetchSize(this.data.getFetchSize()).allowFiltering(this.data.getAllowFiltering()).distinct(this.data.getDistinct()));
    }

    public <E> ListEntityReadQuery<E> asEntity(Class<E> objectClass) {
        return new ListEntityReadQuery<E>(this.getContext(), this, objectClass);
    }

    @Override
    public RecordList execute() {
        return ListenableFutures.getUninterruptibly(this.executeAsync());
    }

    @Override
    public ListenableFuture<RecordList> executeAsync() {
        ListenableFuture<ListReadQueryData> queryDataFuture = this.executeRequestInterceptorsAsync((ListenableFuture<ListReadQueryData>)Futures.immediateFuture((Object)this.data));
        Function<ListReadQueryData, ListenableFuture<RecordList>> queryExecutor = new Function<ListReadQueryData, ListenableFuture<RecordList>>(){

            public ListenableFuture<RecordList> apply(ListReadQueryData querData) {
                return ListReadQuery.this.executeAsync(querData);
            }
        };
        return ListenableFutures.transform(queryDataFuture, queryExecutor, MoreExecutors.directExecutor());
    }

    private ListenableFuture<RecordList> executeAsync(ListReadQueryData queryData) {
        ListenableFuture<ResultSet> resultSetFuture = this.performAsync(ListReadQueryDataImpl.toStatement(queryData, this.getContext()));
        Function<ResultSet, RecordList> resultSetToRecordList = new Function<ResultSet, RecordList>(){

            public RecordList apply(ResultSet resultSet) {
                return new RecordListImpl(ListReadQuery.this.getContext(), resultSet);
            }
        };
        ListenableFuture recordListFuture = Futures.transform(resultSetFuture, (Function)resultSetToRecordList);
        return this.executeResponseInterceptorsAsync(queryData, (ListenableFuture<RecordList>)recordListFuture);
    }

    private ListenableFuture<ListReadQueryData> executeRequestInterceptorsAsync(ListenableFuture<ListReadQueryData> queryDataFuture) {
        UnmodifiableIterator unmodifiableIterator = this.getContext().getInterceptorRegistry().getInterceptors(ListReadQueryRequestInterceptor.class).reverse().iterator();
        while (unmodifiableIterator.hasNext()) {
            ListReadQueryRequestInterceptor interceptor;
            final ListReadQueryRequestInterceptor icptor = interceptor = (ListReadQueryRequestInterceptor)unmodifiableIterator.next();
            Function<ListReadQueryData, ListenableFuture<ListReadQueryData>> mapperFunction = new Function<ListReadQueryData, ListenableFuture<ListReadQueryData>>(){

                public ListenableFuture<ListReadQueryData> apply(ListReadQueryData queryData) {
                    return icptor.onListReadRequestAsync(queryData);
                }
            };
            queryDataFuture = ListenableFutures.transform(queryDataFuture, mapperFunction, this.getContext().getTaskExecutor());
        }
        return queryDataFuture;
    }

    private ListenableFuture<RecordList> executeResponseInterceptorsAsync(final ListReadQueryData queryData, ListenableFuture<RecordList> recordFuture) {
        UnmodifiableIterator unmodifiableIterator = this.getContext().getInterceptorRegistry().getInterceptors(ListReadQueryResponseInterceptor.class).reverse().iterator();
        while (unmodifiableIterator.hasNext()) {
            ListReadQueryResponseInterceptor interceptor;
            final ListReadQueryResponseInterceptor icptor = interceptor = (ListReadQueryResponseInterceptor)unmodifiableIterator.next();
            Function<RecordList, ListenableFuture<RecordList>> mapperFunction = new Function<RecordList, ListenableFuture<RecordList>>(){

                public ListenableFuture<RecordList> apply(RecordList recordList) {
                    return icptor.onListReadResponseAsync(queryData, recordList);
                }
            };
            recordFuture = ListenableFutures.transform(recordFuture, mapperFunction, this.getContext().getTaskExecutor());
        }
        return recordFuture;
    }

    static class CountReadQuery
    extends AbstractQuery<CountReadQuery>
    implements ListRead<Count> {
        private final CountReadQueryData data;

        public CountReadQuery(Context ctx, CountReadQueryData data) {
            super(ctx);
            this.data = data;
        }

        @Override
        protected CountReadQuery newQuery(Context newContext) {
            return new CountReadQuery(newContext, this.data);
        }

        public CountReadQuery withLimit(int limit) {
            return new CountReadQuery(this.getContext(), this.data.limit(limit));
        }

        public CountReadQuery withAllowFiltering() {
            return new CountReadQuery(this.getContext(), this.data.allowFiltering(true));
        }

        public CountReadQuery withFetchSize(int fetchSize) {
            return new CountReadQuery(this.getContext(), this.data.fetchSize(fetchSize));
        }

        public CountReadQuery withDistinct() {
            return new CountReadQuery(this.getContext(), this.data.distinct(true));
        }

        private Statement toStatement(CountReadQueryData queryData) {
            Select.Selection selection = QueryBuilder.select();
            if (queryData.getDistinct() != null && queryData.getDistinct().booleanValue()) {
                selection.distinct();
            }
            selection.countAll();
            Select select = selection.from(this.getContext().getDbSession().getTablename());
            for (Clause whereCondition : queryData.getWhereConditions()) {
                select.where(whereCondition);
            }
            if (queryData.getLimit() != null) {
                select.limit(queryData.getLimit().intValue());
            }
            if (queryData.getAllowFiltering() != null && queryData.getAllowFiltering().booleanValue()) {
                select.allowFiltering();
            }
            if (queryData.getFetchSize() != null) {
                select.setFetchSize(queryData.getFetchSize().intValue());
            }
            return select;
        }

        @Override
        public Count execute() {
            return ListenableFutures.getUninterruptibly(this.executeAsync());
        }

        @Override
        public ListenableFuture<Count> executeAsync() {
            ListenableFuture<ResultSet> future = this.performAsync(this.toStatement(this.data));
            Function<ResultSet, Count> mapEntity = new Function<ResultSet, Count>(){

                public Count apply(ResultSet resultSet) {
                    return Count.newCountResult(resultSet);
                }
            };
            return Futures.transform(future, (Function)mapEntity);
        }
    }

    private static final class CountReadQueryData {
        final ImmutableSet<Clause> whereClauses;
        final Integer limit;
        final Boolean allowFiltering;
        final Integer fetchSize;
        final Boolean distinct;

        public CountReadQueryData() {
            this((ImmutableSet<Clause>)ImmutableSet.of(), null, null, null, null);
        }

        private CountReadQueryData(ImmutableSet<Clause> whereClauses, Integer limit, Boolean allowFiltering, Integer fetchSize, Boolean distinct) {
            this.whereClauses = whereClauses;
            this.limit = limit;
            this.allowFiltering = allowFiltering;
            this.fetchSize = fetchSize;
            this.distinct = distinct;
        }

        public CountReadQueryData whereConditions(ImmutableSet<Clause> whereClauses) {
            return new CountReadQueryData(whereClauses, this.limit, this.allowFiltering, this.fetchSize, this.distinct);
        }

        public CountReadQueryData limit(Integer limit) {
            return new CountReadQueryData(this.whereClauses, limit, this.allowFiltering, this.fetchSize, this.distinct);
        }

        public CountReadQueryData allowFiltering(Boolean allowFiltering) {
            return new CountReadQueryData(this.whereClauses, this.limit, allowFiltering, this.fetchSize, this.distinct);
        }

        public CountReadQueryData fetchSize(Integer fetchSize) {
            return new CountReadQueryData(this.whereClauses, this.limit, this.allowFiltering, fetchSize, this.distinct);
        }

        public CountReadQueryData distinct(Boolean distinct) {
            return new CountReadQueryData(this.whereClauses, this.limit, this.allowFiltering, this.fetchSize, distinct);
        }

        public ImmutableSet<Clause> getWhereConditions() {
            return this.whereClauses;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public Boolean getAllowFiltering() {
            return this.allowFiltering;
        }

        public Integer getFetchSize() {
            return this.fetchSize;
        }

        public Boolean getDistinct() {
            return this.distinct;
        }
    }

    private static class EntityListImpl<F>
    implements EntityList<F> {
        private final Context ctx;
        private final RecordList recordList;
        private final Class<F> clazz;

        EntityListImpl(Context ctx, RecordList recordList, Class<F> clazz) {
            this.ctx = ctx;
            this.recordList = recordList;
            this.clazz = clazz;
        }

        @Override
        public ExecutionInfo getExecutionInfo() {
            return this.recordList.getExecutionInfo();
        }

        @Override
        public ImmutableList<ExecutionInfo> getAllExecutionInfo() {
            return this.recordList.getAllExecutionInfo();
        }

        @Override
        public boolean wasApplied() {
            return this.recordList.wasApplied();
        }

        @Override
        public Iterator<F> iterator() {
            return new Iterator<F>(){
                private final Iterator<Record> recordIt;
                {
                    this.recordIt = EntityListImpl.this.recordList.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.recordIt.hasNext();
                }

                @Override
                public F next() {
                    return EntityListImpl.this.ctx.getBeanMapper().fromValues(EntityListImpl.this.clazz, RecordImpl.toPropertiesSource(this.recordIt.next()), EntityListImpl.this.ctx.getDbSession().getColumnNames());
                }
            };
        }

        public void subscribe(Subscriber<? super F> subscriber) {
            this.recordList.subscribe(new MappingSubscriber<F>(this.ctx, this.clazz, subscriber));
        }

        private final class MappingSubscriber<G>
        implements Subscriber<Record> {
            private final Context ctx;
            private final Class<?> clazz;
            private Subscriber<? super G> subscriber;

            public MappingSubscriber(Context ctx, Class<?> clazz, Subscriber<? super G> subscriber) {
                this.ctx = ctx;
                this.clazz = clazz;
                this.subscriber = subscriber;
            }

            public void onSubscribe(Subscription subscription) {
                this.subscriber.onSubscribe(subscription);
            }

            public void onNext(Record record) {
                this.subscriber.onNext(this.ctx.getBeanMapper().fromValues(this.clazz, RecordImpl.toPropertiesSource(record), this.ctx.getDbSession().getColumnNames()));
            }

            public void onError(Throwable t) {
                this.subscriber.onError(t);
            }

            public void onComplete() {
                this.subscriber.onComplete();
            }
        }
    }

    private static class RecordListImpl
    implements RecordList {
        private static final Logger LOG = LoggerFactory.getLogger(RecordListImpl.class);
        private final Context ctx;
        private final ResultSet rs;
        private final Iterator<Row> iterator;
        private boolean subscribed = false;

        RecordListImpl(Context ctx, ResultSet rs) {
            this.ctx = ctx;
            this.rs = rs;
            this.iterator = rs.iterator();
        }

        @Override
        public ExecutionInfo getExecutionInfo() {
            return this.rs.getExecutionInfo();
        }

        @Override
        public ImmutableList<ExecutionInfo> getAllExecutionInfo() {
            return ImmutableList.copyOf((Collection)this.rs.getAllExecutionInfo());
        }

        @Override
        public boolean wasApplied() {
            return this.rs.wasApplied();
        }

        @Override
        public Iterator<Record> iterator() {
            return new Iterator<Record>(){

                @Override
                public boolean hasNext() {
                    return RecordListImpl.this.iterator.hasNext();
                }

                @Override
                public Record next() {
                    return new RecordImpl(RecordListImpl.this.ctx, RecordListImpl.this, (Row)RecordListImpl.this.iterator.next());
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscribe(Subscriber<? super Record> subscriber) {
            RecordListImpl recordListImpl = this;
            synchronized (recordListImpl) {
                if (this.subscribed) {
                    subscriber.onError((Throwable)new IllegalStateException("subscription already exists. Multi-subscribe is not supported"));
                } else {
                    this.subscribed = true;
                    subscriber.onSubscribe((Subscription)new DatabaseSubscription(subscriber));
                }
            }
        }

        private final class DatabaseSubscription
        implements Subscription {
            private boolean isOpen = true;
            private final Object subscriberCallbackLock = new Object();
            private final Object dbQueryLock = new Object();
            private final Subscriber<? super Record> subscriber;
            private final Iterator<? extends Record> it;
            private final AtomicLong numPendingReads = new AtomicLong();
            private final AtomicReference<Runnable> runningDatabaseQuery = new AtomicReference();

            public DatabaseSubscription(Subscriber<? super Record> subscriber) {
                this.subscriber = subscriber;
                this.it = RecordListImpl.this.iterator();
            }

            public void request(long n) {
                if (n > 0L) {
                    this.numPendingReads.addAndGet(n);
                    this.processReadRequests();
                }
            }

            private void processReadRequests() {
                this.processAvailableDatabaseRecords();
                if (this.numPendingReads.get() > 0L) {
                    this.requestDatabaseForMoreRecords();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void processAvailableDatabaseRecords() {
                Object object = this.subscriberCallbackLock;
                synchronized (object) {
                    if (this.isOpen) {
                        while (this.it.hasNext() && this.numPendingReads.get() > 0L) {
                            try {
                                this.numPendingReads.decrementAndGet();
                                this.subscriber.onNext((Object)this.it.next());
                            }
                            catch (RuntimeException rt) {
                                LOG.warn("processing error occured", (Throwable)rt);
                                this.teminateWithError(rt);
                            }
                        }
                    } else {
                        this.subscriber.onError((Throwable)new IllegalStateException("already closed"));
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void requestDatabaseForMoreRecords() {
                if (RecordListImpl.this.rs.isFullyFetched()) {
                    this.terminateRegularly();
                    return;
                }
                Object object = this.dbQueryLock;
                synchronized (object) {
                    if (this.runningDatabaseQuery.get() == null) {
                        Runnable databaseRequest = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = DatabaseSubscription.this.dbQueryLock;
                                synchronized (object) {
                                    DatabaseSubscription.this.runningDatabaseQuery.set(null);
                                }
                                DatabaseSubscription.this.processReadRequests();
                            }
                        };
                        this.runningDatabaseQuery.set(databaseRequest);
                        ListenableFuture future = RecordListImpl.this.rs.fetchMoreResults();
                        future.addListener(databaseRequest, RecordListImpl.this.ctx.getTaskExecutor());
                    }
                }
            }

            public void cancel() {
                this.terminateRegularly();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void terminateRegularly() {
                Object object = this.subscriberCallbackLock;
                synchronized (object) {
                    if (this.isOpen) {
                        this.isOpen = false;
                        this.subscriber.onComplete();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void teminateWithError(Throwable t) {
                Object object = this.subscriberCallbackLock;
                synchronized (object) {
                    if (this.isOpen) {
                        this.isOpen = false;
                        this.subscriber.onError(t);
                    }
                }
            }
        }
    }

    static class ListEntityReadQuery<E>
    extends AbstractQuery<ListEntityReadQuery<E>>
    implements ListRead<EntityList<E>> {
        private final ListReadQuery query;
        private final Class<E> clazz;

        ListEntityReadQuery(Context ctx, ListReadQuery query, Class<E> clazz) {
            super(ctx);
            this.query = query;
            this.clazz = clazz;
        }

        @Override
        protected ListEntityReadQuery<E> newQuery(Context newContext) {
            return new ListReadQuery(newContext, this.query.data).asEntity((Class)this.clazz);
        }

        @Override
        public ListEntityReadQuery<E> withDistinct() {
            return this.query.withDistinct().asEntity((Class)this.clazz);
        }

        @Override
        public ListEntityReadQuery<E> withFetchSize(int fetchSize) {
            return this.query.withFetchSize(fetchSize).asEntity((Class)this.clazz);
        }

        @Override
        public ListEntityReadQuery<E> withAllowFiltering() {
            return this.query.withAllowFiltering().asEntity((Class)this.clazz);
        }

        @Override
        public ListEntityReadQuery<E> withLimit(int limit) {
            return this.query.withLimit(limit).asEntity((Class)this.clazz);
        }

        @Override
        public EntityList<E> execute() {
            return ListenableFutures.getUninterruptibly(this.executeAsync());
        }

        @Override
        public ListenableFuture<EntityList<E>> executeAsync() {
            ListenableFuture<RecordList> future = this.query.executeAsync();
            Function mapEntity = new Function<RecordList, EntityList<E>>(){

                public EntityList<E> apply(RecordList recordList) {
                    return new EntityListImpl(ListEntityReadQuery.this.getContext(), recordList, ListEntityReadQuery.this.clazz);
                }
            };
            return Futures.transform(future, (Function)mapEntity);
        }
    }
}

