/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import net.oneandone.troilus.Context;
import net.oneandone.troilus.java7.interceptor.ListReadQueryData;

class ListReadQueryDataImpl
implements ListReadQueryData {
    private final ImmutableMap<String, ImmutableList<Object>> keys;
    private final ImmutableSet<Clause> whereClauses;
    private final ImmutableMap<String, Boolean> columnsToFetch;
    private final Integer limit;
    private final Boolean allowFiltering;
    private final Integer fetchSize;
    private final Boolean distinct;

    ListReadQueryDataImpl() {
        this((ImmutableMap<String, ImmutableList<Object>>)ImmutableMap.of(), (ImmutableSet<Clause>)ImmutableSet.of(), (ImmutableMap<String, Boolean>)ImmutableMap.of(), null, null, null, null);
    }

    private ListReadQueryDataImpl(ImmutableMap<String, ImmutableList<Object>> keys, ImmutableSet<Clause> whereClauses, ImmutableMap<String, Boolean> columnsToFetch, Integer limit, Boolean allowFiltering, Integer fetchSize, Boolean distinct) {
        this.keys = keys;
        this.whereClauses = whereClauses;
        this.columnsToFetch = columnsToFetch;
        this.limit = limit;
        this.allowFiltering = allowFiltering;
        this.fetchSize = fetchSize;
        this.distinct = distinct;
    }

    @Override
    public ListReadQueryDataImpl keys(ImmutableMap<String, ImmutableList<Object>> keys) {
        return new ListReadQueryDataImpl(keys, this.whereClauses, this.columnsToFetch, this.limit, this.allowFiltering, this.fetchSize, this.distinct);
    }

    @Override
    public ListReadQueryDataImpl whereConditions(ImmutableSet<Clause> whereClauses) {
        return new ListReadQueryDataImpl(this.keys, whereClauses, this.columnsToFetch, this.limit, this.allowFiltering, this.fetchSize, this.distinct);
    }

    @Override
    public ListReadQueryDataImpl columnsToFetch(ImmutableMap<String, Boolean> columnsToFetch) {
        return new ListReadQueryDataImpl(this.keys, this.whereClauses, columnsToFetch, this.limit, this.allowFiltering, this.fetchSize, this.distinct);
    }

    @Override
    public ListReadQueryDataImpl limit(Integer limit) {
        return new ListReadQueryDataImpl(this.keys, this.whereClauses, this.columnsToFetch, limit, this.allowFiltering, this.fetchSize, this.distinct);
    }

    @Override
    public ListReadQueryDataImpl allowFiltering(Boolean allowFiltering) {
        return new ListReadQueryDataImpl(this.keys, this.whereClauses, this.columnsToFetch, this.limit, allowFiltering, this.fetchSize, this.distinct);
    }

    @Override
    public ListReadQueryDataImpl fetchSize(Integer fetchSize) {
        return new ListReadQueryDataImpl(this.keys, this.whereClauses, this.columnsToFetch, this.limit, this.allowFiltering, fetchSize, this.distinct);
    }

    @Override
    public ListReadQueryDataImpl distinct(Boolean distinct) {
        return new ListReadQueryDataImpl(this.keys, this.whereClauses, this.columnsToFetch, this.limit, this.allowFiltering, this.fetchSize, distinct);
    }

    @Override
    public ImmutableMap<String, ImmutableList<Object>> getKeys() {
        return this.keys;
    }

    @Override
    public ImmutableSet<Clause> getWhereConditions() {
        return this.whereClauses;
    }

    @Override
    public ImmutableMap<String, Boolean> getColumnsToFetch() {
        return this.columnsToFetch;
    }

    @Override
    public Integer getLimit() {
        return this.limit;
    }

    @Override
    public Boolean getAllowFiltering() {
        return this.allowFiltering;
    }

    @Override
    public Integer getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public Boolean getDistinct() {
        return this.distinct;
    }

    static Statement toStatement(ListReadQueryData data, Context ctx) {
        Select.Selection selection = QueryBuilder.select();
        if (data.getDistinct() != null && data.getDistinct().booleanValue()) {
            selection.distinct();
        }
        if (data.getColumnsToFetch().isEmpty()) {
            selection.all();
        } else {
            for (Map.Entry entry : data.getColumnsToFetch().entrySet()) {
                selection.column((String)entry.getKey());
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                selection.ttl((String)entry.getKey());
                selection.writeTime((String)entry.getKey());
            }
        }
        Select select = selection.from(ctx.getDbSession().getTablename());
        if (data.getLimit() != null) {
            select.limit(data.getLimit().intValue());
        }
        if (data.getAllowFiltering() != null && data.getAllowFiltering().booleanValue()) {
            select.allowFiltering();
        }
        if (data.getFetchSize() != null) {
            select.setFetchSize(data.getFetchSize().intValue());
        }
        if (data.getKeys().isEmpty()) {
            for (Clause whereClause : data.getWhereConditions()) {
                select.where(whereClause);
            }
            return select;
        }
        ArrayList values = Lists.newArrayList();
        for (Map.Entry entry : data.getKeys().entrySet()) {
            if (((ImmutableList)entry.getValue()).size() == 1) {
                select.where(QueryBuilder.eq((String)((String)entry.getKey()), (Object)QueryBuilder.bindMarker()));
                values.add(ctx.toStatementValue((String)entry.getKey(), ((ImmutableList)entry.getValue()).get(0)));
                continue;
            }
            select.where(QueryBuilder.in((String)((String)entry.getKey()), (Object[])new Object[]{QueryBuilder.bindMarker()}));
            values.add(ctx.toStatementValues((String)entry.getKey(), (ImmutableList<Object>)((ImmutableList)entry.getValue())));
        }
        return ctx.getDbSession().prepare((BuiltStatement)select).bind(values.toArray());
    }
}

