/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.google.common.base.Function;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class ListenableFutures {
    private ListenableFutures() {
    }

    public static <T> T getUninterruptibly(ListenableFuture<T> future) {
        try {
            return (T)future.get();
        }
        catch (InterruptedException | RuntimeException | ExecutionException e) {
            throw ListenableFutures.unwrapIfNecessary(e);
        }
    }

    public static <T, E> ListenableFuture<E> transform(ListenableFuture<T> future, Function<T, ListenableFuture<E>> mapperFunction, Executor executor) {
        return new QueryFuture<T, E>(future, mapperFunction, executor);
    }

    public static RuntimeException unwrapIfNecessary(Throwable throwable) {
        return ListenableFutures.unwrapIfNecessary(throwable, 5);
    }

    private static RuntimeException unwrapIfNecessary(Throwable throwable, int maxDepth) {
        if (ExecutionException.class.isAssignableFrom(throwable.getClass())) {
            Throwable e = ((ExecutionException)throwable).getCause();
            if (maxDepth > 1) {
                throwable = ListenableFutures.unwrapIfNecessary(e, maxDepth - 1);
            }
        }
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }

    private static final class QueryFuture<T, E>
    extends AbstractFuture<E>
    implements Runnable {
        private final ListenableFuture<T> future;
        private final Function<T, ListenableFuture<E>> func;

        public QueryFuture(ListenableFuture<T> future, Function<T, ListenableFuture<E>> func, Executor executor) {
            this.future = future;
            this.func = func;
            future.addListener((Runnable)this, executor);
        }

        @Override
        public void run() {
            try {
                final ListenableFuture iFuture = (ListenableFuture)this.func.apply(this.future.get());
                Runnable resultForwarder = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            QueryFuture.this.set(iFuture.get());
                        }
                        catch (InterruptedException | RuntimeException | ExecutionException e) {
                            QueryFuture.this.setException(ListenableFutures.unwrapIfNecessary(e));
                        }
                    }
                };
                iFuture.addListener(resultForwarder, MoreExecutors.directExecutor());
            }
            catch (InterruptedException | RuntimeException | ExecutionException e) {
                this.setException(ListenableFutures.unwrapIfNecessary(e));
            }
        }
    }
}

