/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class Optionals {
    private static final Class<?> JAVA_OPTIONAL_CLASS;
    private static final Method JAVA_OPTIONAL_OR_ELSE_METH;

    private Optionals() {
    }

    private static boolean isJavaOptional(Object obj) {
        if (obj != null && JAVA_OPTIONAL_CLASS != null) {
            return JAVA_OPTIONAL_CLASS.isAssignableFrom(obj.getClass());
        }
        return false;
    }

    private static <T> T fromJavaOptional(Object obj) {
        if (obj != null && JAVA_OPTIONAL_OR_ELSE_METH != null) {
            try {
                return (T)JAVA_OPTIONAL_OR_ELSE_METH.invoke(obj, new Object[]{null});
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return (T)obj;
    }

    private static boolean isGuavaOptional(Object obj) {
        return obj == null ? false : Optional.class.isAssignableFrom(obj.getClass());
    }

    public static <T> Optional<T> toGuavaOptional(T obj) {
        if (obj == null) {
            return Optional.absent();
        }
        if (Optionals.isGuavaOptional(obj)) {
            return (Optional)obj;
        }
        if (Optionals.isJavaOptional(obj)) {
            return Optional.fromNullable(Optionals.fromJavaOptional(obj));
        }
        return Optional.of(obj);
    }

    public static ImmutableMap<String, Optional<Object>> toGuavaOptional(ImmutableMap<String, Object> map) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry entry : map.entrySet()) {
            result.put(entry.getKey(), Optionals.toGuavaOptional(entry.getValue()));
        }
        return ImmutableMap.copyOf((Map)result);
    }

    static {
        Class<?> clazz = null;
        Method meth = null;
        try {
            clazz = Class.forName("java.util.Optional");
            meth = clazz.getMethod("orElse", Object.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        JAVA_OPTIONAL_CLASS = clazz;
        JAVA_OPTIONAL_OR_ELSE_METH = meth;
    }
}

