/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.UDTValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import net.oneandone.troilus.ColumnName;
import net.oneandone.troilus.Context;
import net.oneandone.troilus.PropertiesSource;
import net.oneandone.troilus.Result;
import net.oneandone.troilus.UDTValueMapper;
import net.oneandone.troilus.java7.Record;

class RecordImpl
implements Record {
    private final Context ctx;
    private final Result result;
    private final Row row;
    private final PropertiesSourceAdapter propertiesSourceAdapter;

    RecordImpl(Context ctx, Result result, Row row) {
        this.ctx = ctx;
        this.result = result;
        this.row = row;
        this.propertiesSourceAdapter = new PropertiesSourceAdapter(this);
    }

    Row getRow() {
        return this.row;
    }

    ColumnDefinitions getColumnDefinitions() {
        return this.row.getColumnDefinitions();
    }

    @Override
    public ExecutionInfo getExecutionInfo() {
        return this.result.getExecutionInfo();
    }

    @Override
    public ImmutableList<ExecutionInfo> getAllExecutionInfo() {
        return this.result.getAllExecutionInfo();
    }

    @Override
    public boolean wasApplied() {
        return this.result.wasApplied();
    }

    @Override
    public Long getWritetime(String name) {
        try {
            return this.row.getLong("WRITETIME(" + name + ")");
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    @Override
    public Integer getTtl(String name) {
        try {
            return this.row.getInt("TTL(" + name + ")");
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    @Override
    public boolean isNull(String name) {
        return this.row.isNull(name);
    }

    @Override
    public Long getLong(String name) {
        return this.row.getLong(name);
    }

    @Override
    public String getString(String name) {
        return this.row.getString(name);
    }

    @Override
    public Boolean getBool(String name) {
        return this.row.getBool(name);
    }

    @Override
    public ByteBuffer getBytes(String name) {
        return this.row.getBytes(name);
    }

    @Override
    public ByteBuffer getBytesUnsafe(String name) {
        return this.row.getBytesUnsafe(name);
    }

    @Override
    public Float getFloat(String name) {
        return Float.valueOf(this.row.getFloat(name));
    }

    @Override
    public Date getDate(String name) {
        return this.row.getDate(name);
    }

    @Override
    public BigDecimal getDecimal(String name) {
        return this.row.getDecimal(name);
    }

    @Override
    public Integer getInt(String name) {
        return this.row.getInt(name);
    }

    @Override
    public InetAddress getInet(String name) {
        return this.row.getInet(name);
    }

    @Override
    public BigInteger getVarint(String name) {
        return this.row.getVarint(name);
    }

    @Override
    public UUID getUUID(String name) {
        return this.row.getUUID(name);
    }

    @Override
    public UDTValue getUDTValue(String name) {
        return this.row.getUDTValue(name);
    }

    @Override
    public <T extends Enum<T>> T getEnum(String name, Class<T> enumType) {
        return (T)((Enum)this.getObject(name, enumType));
    }

    @Override
    public <T> T getValue(ColumnName<T> name) {
        return (T)name.read(this.propertiesSourceAdapter).orNull();
    }

    @Override
    public <T> T getObject(String name, Class<T> elementsClass) {
        if (this.isNull(name)) {
            return null;
        }
        DataType datatype = this.getColumnDefinitions().getType(name);
        if (datatype != null) {
            if (UDTValueMapper.isBuildInType(datatype)) {
                Object obj = datatype.deserialize(this.getBytesUnsafe(name), this.ctx.getDbSession().getProtocolVersion());
                if (obj != null && this.ctx.isTextDataType(datatype) && Enum.class.isAssignableFrom(elementsClass)) {
                    return Enum.valueOf(elementsClass, obj.toString());
                }
                if (obj != null && datatype.equals(DataType.blob()) && byte[].class.isAssignableFrom(elementsClass)) {
                    ByteBuffer bb = (ByteBuffer)obj;
                    byte[] bytes = new byte[bb.remaining()];
                    bb.get(bytes, 0, bytes.length);
                    return (T)bytes;
                }
                return (T)obj;
            }
            return this.ctx.getDbSession().getUDTValueMapper().fromUdtValue(datatype, this.getUDTValue(name), elementsClass);
        }
        return null;
    }

    @Override
    public <T> ImmutableSet<T> getSet(String name, Class<T> elementsClass) {
        if (this.isNull(name)) {
            return null;
        }
        DataType datatype = this.ctx.getDbSession().getColumnMetadata(name).getType();
        if (UDTValueMapper.isBuildInType(datatype)) {
            return ImmutableSet.copyOf((Collection)this.getRow().getSet(name, elementsClass));
        }
        return this.ctx.getDbSession().getUDTValueMapper().fromUdtValues((DataType)datatype.getTypeArguments().get(0), (ImmutableSet<UDTValue>)ImmutableSet.copyOf((Collection)this.getRow().getSet(name, UDTValue.class)), elementsClass);
    }

    @Override
    public <T> ImmutableList<T> getList(String name, Class<T> elementsClass) {
        if (this.isNull(name)) {
            return null;
        }
        DataType datatype = this.ctx.getDbSession().getColumnMetadata(name).getType();
        if (UDTValueMapper.isBuildInType(datatype)) {
            return ImmutableList.copyOf((Collection)this.getRow().getList(name, elementsClass));
        }
        return this.ctx.getDbSession().getUDTValueMapper().fromUdtValues((DataType)datatype.getTypeArguments().get(0), (ImmutableList<UDTValue>)ImmutableList.copyOf((Collection)this.getRow().getList(name, UDTValue.class)), elementsClass);
    }

    @Override
    public <K, V> ImmutableMap<K, V> getMap(String name, Class<K> keysClass, Class<V> valuesClass) {
        if (this.isNull(name)) {
            return null;
        }
        DataType datatype = this.ctx.getDbSession().getColumnMetadata(name).getType();
        if (UDTValueMapper.isBuildInType(datatype)) {
            return ImmutableMap.copyOf((Map)this.getRow().getMap(name, keysClass, valuesClass));
        }
        if (UDTValueMapper.isBuildInType((DataType)datatype.getTypeArguments().get(0))) {
            return this.ctx.getDbSession().getUDTValueMapper().fromUdtValues((DataType)datatype.getTypeArguments().get(0), (DataType)datatype.getTypeArguments().get(1), ImmutableMap.copyOf((Map)this.getRow().getMap(name, keysClass, UDTValue.class)), keysClass, valuesClass);
        }
        if (UDTValueMapper.isBuildInType((DataType)datatype.getTypeArguments().get(1))) {
            return this.ctx.getDbSession().getUDTValueMapper().fromUdtValues((DataType)datatype.getTypeArguments().get(0), (DataType)datatype.getTypeArguments().get(1), ImmutableMap.copyOf((Map)this.getRow().getMap(name, UDTValue.class, valuesClass)), keysClass, valuesClass);
        }
        return this.ctx.getDbSession().getUDTValueMapper().fromUdtValues((DataType)datatype.getTypeArguments().get(0), (DataType)datatype.getTypeArguments().get(1), ImmutableMap.copyOf((Map)this.getRow().getMap(name, UDTValue.class, UDTValue.class)), keysClass, valuesClass);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
        for (ColumnDefinitions.Definition definition : this.getRow().getColumnDefinitions().asList()) {
            toStringHelper.add(definition.getName(), (Object)this.toString(definition.getName(), definition.getType()));
        }
        return toStringHelper.toString();
    }

    private String toString(String name, DataType dataType) {
        if (this.isNull(name)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(dataType.deserialize(this.getRow().getBytesUnsafe(name), this.ctx.getDbSession().getProtocolVersion()));
        return builder.toString();
    }

    static PropertiesSource toPropertiesSource(Record record) {
        return new PropertiesSourceAdapter(record);
    }

    private static class PropertiesSourceAdapter
    implements PropertiesSource {
        private final Record record;

        public PropertiesSourceAdapter(Record record) {
            this.record = record;
        }

        @Override
        public <T> Optional<T> read(String name, Class<?> clazz1) {
            return this.read(name, clazz1, Object.class);
        }

        @Override
        public <T> Optional<T> read(String name, Class<?> clazz1, Class<?> clazz2) {
            Object value = this.record.getObject(name, clazz1);
            if (value == null) {
                return Optional.absent();
            }
            return Optional.of(value);
        }
    }
}

