/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.oneandone.troilus.AbstractQuery;
import net.oneandone.troilus.ColumnName;
import net.oneandone.troilus.Context;
import net.oneandone.troilus.Immutables;
import net.oneandone.troilus.ListenableFutures;
import net.oneandone.troilus.ProtocolErrorException;
import net.oneandone.troilus.RecordImpl;
import net.oneandone.troilus.SingleReadQueryDataImpl;
import net.oneandone.troilus.TooManyResultsException;
import net.oneandone.troilus.interceptor.SingleReadQueryData;
import net.oneandone.troilus.java7.Record;
import net.oneandone.troilus.java7.SingleRead;
import net.oneandone.troilus.java7.SingleReadWithUnit;
import net.oneandone.troilus.java7.interceptor.SingleReadQueryRequestInterceptor;
import net.oneandone.troilus.java7.interceptor.SingleReadQueryResponseInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SingleReadQuery
extends AbstractQuery<SingleReadQuery>
implements SingleReadWithUnit<Record> {
    private static final Logger LOG = LoggerFactory.getLogger(SingleReadQuery.class);
    private final SingleReadQueryData data;

    SingleReadQuery(Context ctx, SingleReadQueryData data) {
        super(ctx);
        this.data = data;
    }

    @Override
    protected SingleReadQuery newQuery(Context newContext) {
        return new SingleReadQuery(newContext, this.data);
    }

    public SingleReadQuery all() {
        return new SingleReadQuery(this.getContext(), this.data.columnsToFetch((ImmutableMap<String, Boolean>)ImmutableMap.of()));
    }

    public SingleReadQuery column(String name) {
        return new SingleReadQuery(this.getContext(), this.data.columnsToFetch(Immutables.merge(this.data.getColumnsToFetch(), name, false)));
    }

    public SingleReadQuery columnWithMetadata(String name) {
        return new SingleReadQuery(this.getContext(), this.data.columnsToFetch(Immutables.merge(this.data.getColumnsToFetch(), name, true)));
    }

    public SingleReadQuery columns(String ... names) {
        return this.columns((ImmutableList<String>)ImmutableList.copyOf((Object[])names));
    }

    private SingleReadQuery columns(ImmutableList<String> names) {
        SingleReadQuery read = this;
        for (String columnName : names) {
            read = read.column(columnName);
        }
        return read;
    }

    public SingleReadQuery column(ColumnName<?> name) {
        return this.column(name.getName());
    }

    public SingleReadQuery columnWithMetadata(ColumnName<?> name) {
        return this.column(name.getName());
    }

    public SingleReadQuery columns(ColumnName<?> ... names) {
        ArrayList ns = Lists.newArrayList();
        for (ColumnName<?> name : names) {
            ns.add(name.getName());
        }
        return this.columns((ImmutableList<String>)ImmutableList.copyOf((Collection)ns));
    }

    @Override
    public <E> SingleEntityReadQuery<E> asEntity(Class<E> objectClass) {
        return new SingleEntityReadQuery<E>(this.getContext(), this, objectClass);
    }

    @Override
    public Record execute() {
        return ListenableFutures.getUninterruptibly(this.executeAsync());
    }

    @Override
    public ListenableFuture<Record> executeAsync() {
        ListenableFuture<SingleReadQueryData> queryDataFuture = this.executeRequestInterceptorsAsync((ListenableFuture<SingleReadQueryData>)Futures.immediateFuture((Object)this.data));
        Function<SingleReadQueryData, ListenableFuture<Record>> queryExecutor = new Function<SingleReadQueryData, ListenableFuture<Record>>(){

            public ListenableFuture<Record> apply(SingleReadQueryData querData) {
                return SingleReadQuery.this.executeAsync(querData);
            }
        };
        return ListenableFutures.transform(queryDataFuture, queryExecutor, MoreExecutors.directExecutor());
    }

    private ListenableFuture<Record> executeAsync(SingleReadQueryData queryData) {
        ListenableFuture<ResultSet> resultSetFuture = this.performAsync(SingleReadQueryDataImpl.toStatement(queryData, this.getContext()));
        Function<ResultSet, Record> resultSetToRecord = new Function<ResultSet, Record>(){

            public Record apply(ResultSet resultSet) {
                Row row = resultSet.one();
                if (row == null) {
                    return null;
                }
                if (!resultSet.isExhausted()) {
                    throw new TooManyResultsException(SingleReadQuery.this.newResult(resultSet), "more than one record exists");
                }
                RecordImpl record = new RecordImpl(SingleReadQuery.this.getContext(), SingleReadQuery.this.newResult(resultSet), row);
                SingleReadQuery.this.paranoiaCheck(record);
                return record;
            }
        };
        ListenableFuture recordFuture = Futures.transform(resultSetFuture, (Function)resultSetToRecord);
        return this.executeResponseInterceptorsAsync(queryData, (ListenableFuture<Record>)recordFuture);
    }

    private ListenableFuture<SingleReadQueryData> executeRequestInterceptorsAsync(ListenableFuture<SingleReadQueryData> queryDataFuture) {
        UnmodifiableIterator unmodifiableIterator = this.getContext().getInterceptorRegistry().getInterceptors(SingleReadQueryRequestInterceptor.class).reverse().iterator();
        while (unmodifiableIterator.hasNext()) {
            SingleReadQueryRequestInterceptor interceptor;
            final SingleReadQueryRequestInterceptor icptor = interceptor = (SingleReadQueryRequestInterceptor)unmodifiableIterator.next();
            Function<SingleReadQueryData, ListenableFuture<SingleReadQueryData>> mapperFunction = new Function<SingleReadQueryData, ListenableFuture<SingleReadQueryData>>(){

                public ListenableFuture<SingleReadQueryData> apply(SingleReadQueryData queryData) {
                    return icptor.onSingleReadRequestAsync(queryData);
                }
            };
            queryDataFuture = ListenableFutures.transform(queryDataFuture, mapperFunction, this.getContext().getTaskExecutor());
        }
        return queryDataFuture;
    }

    private ListenableFuture<Record> executeResponseInterceptorsAsync(final SingleReadQueryData queryData, ListenableFuture<Record> recordFuture) {
        UnmodifiableIterator unmodifiableIterator = this.getContext().getInterceptorRegistry().getInterceptors(SingleReadQueryResponseInterceptor.class).reverse().iterator();
        while (unmodifiableIterator.hasNext()) {
            SingleReadQueryResponseInterceptor interceptor;
            final SingleReadQueryResponseInterceptor icptor = interceptor = (SingleReadQueryResponseInterceptor)unmodifiableIterator.next();
            Function<Record, ListenableFuture<Record>> mapperFunction = new Function<Record, ListenableFuture<Record>>(){

                public ListenableFuture<Record> apply(Record record) {
                    return icptor.onSingleReadResponseAsync(queryData, record);
                }
            };
            recordFuture = ListenableFutures.transform(recordFuture, mapperFunction, this.getContext().getTaskExecutor());
        }
        return recordFuture;
    }

    private Record paranoiaCheck(Record record) {
        for (Map.Entry entry : this.data.getKey().entrySet()) {
            ByteBuffer out;
            ByteBuffer in = DataType.serializeValue(entry.getValue(), (ProtocolVersion)this.getContext().getDbSession().getProtocolVersion());
            if (in.compareTo(out = record.getBytesUnsafe((String)entry.getKey())) == 0) continue;
            LOG.warn("Dataswap error for " + (String)entry.getKey());
            throw new ProtocolErrorException("Dataswap error for " + (String)entry.getKey());
        }
        return record;
    }

    static class SingleEntityReadQuery<E>
    extends AbstractQuery<SingleEntityReadQuery<E>>
    implements SingleRead<E> {
        private final Class<E> clazz;
        private final SingleReadQuery query;

        SingleEntityReadQuery(Context ctx, SingleReadQuery query, Class<E> clazz) {
            super(ctx);
            this.query = query;
            this.clazz = clazz;
        }

        @Override
        protected SingleEntityReadQuery<E> newQuery(Context newContext) {
            return new SingleReadQuery(newContext, this.query.data).asEntity((Class)this.clazz);
        }

        @Override
        public E execute() {
            return ListenableFutures.getUninterruptibly(this.executeAsync());
        }

        @Override
        public ListenableFuture<E> executeAsync() {
            ListenableFuture<Record> future = this.query.executeAsync();
            Function mapEntity = new Function<Record, E>(){

                public E apply(Record record) {
                    return SingleEntityReadQuery.this.getContext().getBeanMapper().fromValues(SingleEntityReadQuery.this.clazz, RecordImpl.toPropertiesSource(record), SingleEntityReadQuery.this.getContext().getDbSession().getColumnNames());
                }
            };
            return Futures.transform(future, (Function)mapEntity);
        }
    }
}

