/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import net.oneandone.troilus.Context;
import net.oneandone.troilus.interceptor.SingleReadQueryData;

class SingleReadQueryDataImpl
implements SingleReadQueryData {
    final ImmutableMap<String, Object> keyNameValuePartPairs;
    final ImmutableMap<String, Boolean> columnsToFetch;

    SingleReadQueryDataImpl() {
        this((ImmutableMap<String, Object>)ImmutableMap.of(), (ImmutableMap<String, Boolean>)ImmutableMap.of());
    }

    private SingleReadQueryDataImpl(ImmutableMap<String, Object> keyNameValuePartPairs, ImmutableMap<String, Boolean> columnsToFetchs) {
        this.keyNameValuePartPairs = keyNameValuePartPairs;
        this.columnsToFetch = columnsToFetchs;
    }

    @Override
    public SingleReadQueryDataImpl key(ImmutableMap<String, Object> keyNameValuePartPairs) {
        return new SingleReadQueryDataImpl(keyNameValuePartPairs, this.columnsToFetch);
    }

    @Override
    public SingleReadQueryDataImpl columnsToFetch(ImmutableMap<String, Boolean> columnsToFetchs) {
        return new SingleReadQueryDataImpl(this.keyNameValuePartPairs, columnsToFetchs);
    }

    @Override
    public ImmutableMap<String, Object> getKey() {
        return this.keyNameValuePartPairs;
    }

    @Override
    public ImmutableMap<String, Boolean> getColumnsToFetch() {
        return this.columnsToFetch;
    }

    static Statement toStatement(SingleReadQueryData data, Context ctx) {
        Select.Selection selection = QueryBuilder.select();
        if (data.getColumnsToFetch().isEmpty()) {
            selection.all();
        } else {
            for (Map.Entry entry : data.getColumnsToFetch().entrySet()) {
                selection.column((String)entry.getKey());
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                selection.ttl((String)entry.getKey());
                selection.writeTime((String)entry.getKey());
            }
            for (String keyname : data.getKey().keySet()) {
                if (data.getColumnsToFetch().get((Object)keyname) != null) continue;
                selection.column(keyname);
            }
        }
        Select select = selection.from(ctx.getDbSession().getTablename());
        ArrayList values = Lists.newArrayList();
        for (Map.Entry entry : data.getKey().entrySet()) {
            select.where(QueryBuilder.eq((String)((String)entry.getKey()), (Object)QueryBuilder.bindMarker()));
            values.add(ctx.toStatementValue((String)entry.getKey(), entry.getValue()));
        }
        return ctx.getDbSession().prepare((BuiltStatement)select).bind(values.toArray());
    }
}

