/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.google.common.base.Optional;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.oneandone.troilus.BeanMapper;
import net.oneandone.troilus.PropertiesSource;

class UDTValueMapper {
    private final ProtocolVersion protocolVersion;
    private final BeanMapper beanMapper;

    UDTValueMapper(ProtocolVersion protocolVersion, BeanMapper beanMapper) {
        this.protocolVersion = protocolVersion;
        this.beanMapper = beanMapper;
    }

    private UserType getUserType(LoadingCache<String, UserType> userTypeCache, String usertypeName) {
        try {
            return (UserType)userTypeCache.get((Object)usertypeName);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    static boolean isBuildInType(DataType dataType) {
        if (dataType.isCollection()) {
            for (DataType type : dataType.getTypeArguments()) {
                if (UDTValueMapper.isBuildInType(type)) continue;
                return false;
            }
            return true;
        }
        return DataType.allPrimitiveTypes().contains(dataType);
    }

    public Object fromUdtValue(DataType datatype, UDTValue udtValue, Class<?> fieldtype1, Class<?> fieldtype2, String fieldname) {
        if (UDTValueMapper.isBuildInType(datatype)) {
            return datatype.deserialize(udtValue.getBytesUnsafe(fieldname), this.protocolVersion);
        }
        if (datatype.isCollection()) {
            Class type = datatype.getName().asJavaClass();
            if (Set.class.isAssignableFrom(type)) {
                return this.fromUdtValues((DataType)datatype.getTypeArguments().get(0), (ImmutableSet<UDTValue>)ImmutableSet.copyOf((Collection)udtValue.getSet(fieldname, UDTValue.class)), fieldtype1);
            }
            if (List.class.isAssignableFrom(type)) {
                return this.fromUdtValues((DataType)datatype.getTypeArguments().get(0), (ImmutableList<UDTValue>)ImmutableList.copyOf((Collection)udtValue.getList(fieldname, UDTValue.class)), fieldtype1);
            }
            if (UDTValueMapper.isBuildInType((DataType)datatype.getTypeArguments().get(0))) {
                return this.fromUdtValues((DataType)datatype.getTypeArguments().get(0), (DataType)datatype.getTypeArguments().get(1), ImmutableMap.copyOf((Map)udtValue.getMap(fieldname, fieldtype1, UDTValue.class)), fieldtype1, fieldtype2);
            }
            if (UDTValueMapper.isBuildInType((DataType)datatype.getTypeArguments().get(1))) {
                return this.fromUdtValues((DataType)datatype.getTypeArguments().get(0), (DataType)datatype.getTypeArguments().get(1), ImmutableMap.copyOf((Map)udtValue.getMap(fieldname, UDTValue.class, fieldtype2)), fieldtype1, fieldtype2);
            }
            return this.fromUdtValues((DataType)datatype.getTypeArguments().get(0), (DataType)datatype.getTypeArguments().get(1), ImmutableMap.copyOf((Map)udtValue.getMap(fieldname, UDTValue.class, UDTValue.class)), fieldtype1, fieldtype2);
        }
        return this.fromUdtValue(datatype, udtValue, fieldtype1);
    }

    public <T> T fromUdtValue(final DataType datatype, final UDTValue udtValue, Class<T> type) {
        PropertiesSource propsSource = new PropertiesSource(){

            public <E> Optional<E> read(String name, Class<?> clazz1) {
                return this.read(name, clazz1, Object.class);
            }

            public <E> Optional<E> read(String name, Class<?> clazz1, Class<?> clazz2) {
                return Optional.fromNullable((Object)UDTValueMapper.this.fromUdtValue(((UserType)datatype).getFieldType(name), udtValue, clazz1, clazz2, name));
            }
        };
        return this.beanMapper.fromValues(type, propsSource, (ImmutableSet<String>)ImmutableSet.of());
    }

    public <T> ImmutableSet<T> fromUdtValues(DataType datatype, ImmutableSet<UDTValue> udtValues, Class<T> type) {
        return ImmutableSet.copyOf(this.fromUdtValues(datatype, (ImmutableCollection<UDTValue>)udtValues, type));
    }

    public <T> ImmutableList<T> fromUdtValues(DataType datatype, ImmutableList<UDTValue> udtValues, Class<T> type) {
        return this.fromUdtValues(datatype, (ImmutableCollection<UDTValue>)udtValues, type);
    }

    private <T> ImmutableList<T> fromUdtValues(final DataType datatype, ImmutableCollection<UDTValue> udtValues, Class<T> type) {
        ArrayList elements = Lists.newArrayList();
        UnmodifiableIterator unmodifiableIterator = udtValues.iterator();
        while (unmodifiableIterator.hasNext()) {
            UDTValue elementUdtValue;
            final UDTValue elementUdtVal = elementUdtValue = (UDTValue)unmodifiableIterator.next();
            PropertiesSource propsSource = new PropertiesSource(){

                public <E> Optional<E> read(String name, Class<?> clazz1) {
                    return this.read(name, clazz1, Object.class);
                }

                public <E> Optional<E> read(String name, Class<?> clazz1, Class<?> clazz2) {
                    return Optional.fromNullable((Object)UDTValueMapper.this.fromUdtValue(((UserType)datatype).getFieldType(name), elementUdtVal, clazz1, clazz2, name));
                }
            };
            Object element = this.beanMapper.fromValues(type, propsSource, (ImmutableSet<String>)ImmutableSet.of());
            elements.add(element);
        }
        return ImmutableList.copyOf((Collection)elements);
    }

    public <K, V> ImmutableMap<K, V> fromUdtValues(final DataType keyDatatype, final DataType valueDatatype, ImmutableMap<?, ?> udtValues, Class<K> keystype, Class<V> valuesType) {
        HashMap elements = Maps.newHashMap();
        for (Map.Entry entry : udtValues.entrySet()) {
            Object valueElement;
            Object keyElement;
            if (keystype.isAssignableFrom(entry.getKey().getClass())) {
                keyElement = entry.getKey();
            } else {
                final UDTValue keyUdtValue = (UDTValue)entry.getKey();
                PropertiesSource propsSource = new PropertiesSource(){

                    public <E> Optional<E> read(String name, Class<?> clazz1) {
                        return this.read(name, clazz1, Object.class);
                    }

                    @Override
                    public <T> Optional<T> read(String name, Class<?> clazz1, Class<?> clazz2) {
                        return Optional.fromNullable((Object)UDTValueMapper.this.fromUdtValue(((UserType)keyDatatype).getFieldType(name), keyUdtValue, clazz1, clazz2, name));
                    }
                };
                keyElement = this.beanMapper.fromValues(keystype, propsSource, (ImmutableSet<String>)ImmutableSet.of());
            }
            if (valuesType.isAssignableFrom(entry.getValue().getClass())) {
                valueElement = entry.getValue();
            } else {
                final UDTValue valueUdtValue = (UDTValue)entry.getValue();
                PropertiesSource propsSource = new PropertiesSource(){

                    public <E> Optional<E> read(String name, Class<?> clazz1) {
                        return this.read(name, clazz1, Object.class);
                    }

                    @Override
                    public <T> Optional<T> read(String name, Class<?> clazz1, Class<?> clazz2) {
                        return Optional.fromNullable((Object)UDTValueMapper.this.fromUdtValue(((UserType)valueDatatype).getFieldType(name), valueUdtValue, clazz1, clazz2, name));
                    }
                };
                valueElement = this.beanMapper.fromValues(valuesType, propsSource, (ImmutableSet<String>)ImmutableSet.of());
            }
            elements.put(keyElement, valueElement);
        }
        return ImmutableMap.copyOf((Map)elements);
    }

    public Object toUdtValue(LoadingCache<String, UserType> userTypeCache, DataType datatype, Object value) {
        if (UDTValueMapper.isBuildInType(datatype)) {
            return value;
        }
        if (datatype.isCollection()) {
            if (Set.class.isAssignableFrom(datatype.getName().asJavaClass())) {
                DataType elementDataType = (DataType)datatype.getTypeArguments().get(0);
                HashSet udt = Sets.newHashSet();
                if (value != null) {
                    for (Object element : (Set)value) {
                        udt.add(this.toUdtValue(userTypeCache, elementDataType, element));
                    }
                }
                return ImmutableSet.copyOf((Collection)udt);
            }
            if (List.class.isAssignableFrom(datatype.getName().asJavaClass())) {
                DataType elementDataType = (DataType)datatype.getTypeArguments().get(0);
                ArrayList udt = Lists.newArrayList();
                if (value != null) {
                    for (Object element : (List)value) {
                        udt.add(this.toUdtValue(userTypeCache, elementDataType, element));
                    }
                }
                return ImmutableList.copyOf((Collection)udt);
            }
            DataType keyDataType = (DataType)datatype.getTypeArguments().get(0);
            DataType valueDataType = (DataType)datatype.getTypeArguments().get(1);
            HashMap udt = Maps.newHashMap();
            if (value != null) {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    udt.put(this.toUdtValue(userTypeCache, keyDataType, entry.getKey()), this.toUdtValue(userTypeCache, valueDataType, entry.getValue()));
                }
            }
            return ImmutableMap.copyOf((Map)udt);
        }
        if (value == null) {
            return value;
        }
        UserType usertype = this.getUserType(userTypeCache, ((UserType)datatype).getTypeName());
        UDTValue udtValue = usertype.newValue();
        for (Map.Entry entry : this.beanMapper.toValues(value, (ImmutableSet<String>)ImmutableSet.of()).entrySet()) {
            if (!((Optional)entry.getValue()).isPresent()) {
                return null;
            }
            DataType fieldType = usertype.getFieldType((String)entry.getKey());
            Object vl = ((Optional)entry.getValue()).get();
            if (!UDTValueMapper.isBuildInType(usertype.getFieldType((String)entry.getKey()))) {
                vl = this.toUdtValue(userTypeCache, fieldType, vl);
            }
            udtValue.setBytesUnsafe((String)entry.getKey(), fieldType.serialize(vl, this.protocolVersion));
        }
        return udtValue;
    }
}

