/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.google.common.base.Function;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import net.oneandone.troilus.Context;
import net.oneandone.troilus.IfConditionException;
import net.oneandone.troilus.ListenableFutures;
import net.oneandone.troilus.MutationQuery;
import net.oneandone.troilus.Result;
import net.oneandone.troilus.WriteQueryDataImpl;
import net.oneandone.troilus.java7.interceptor.WriteQueryData;
import net.oneandone.troilus.java7.interceptor.WriteQueryRequestInterceptor;

abstract class WriteQuery<Q>
extends MutationQuery<Q> {
    private final WriteQueryDataImpl data;

    WriteQuery(Context ctx, WriteQueryDataImpl data) {
        super(ctx);
        this.data = data;
    }

    protected WriteQueryDataImpl getData() {
        return this.data;
    }

    @Override
    public ListenableFuture<Result> executeAsync() {
        ListenableFuture<ResultSet> future = this.performAsync(this.getStatementAsync());
        Function<ResultSet, Result> mapEntity = new Function<ResultSet, Result>(){

            public Result apply(ResultSet resultSet) {
                Result result = WriteQuery.this.newResult(resultSet);
                if (WriteQuery.this.isLwt() && !result.wasApplied()) {
                    throw new IfConditionException(result, "duplicated entry");
                }
                return result;
            }
        };
        return Futures.transform(future, (Function)mapEntity);
    }

    private boolean isLwt() {
        return this.data.getIfNotExits() != null && this.data.getIfNotExits() != false || !this.data.getOnlyIfConditions().isEmpty();
    }

    @Override
    public ListenableFuture<Statement> getStatementAsync() {
        ListenableFuture<WriteQueryData> queryDataFuture = this.executeRequestInterceptorsAsync((ListenableFuture<WriteQueryData>)Futures.immediateFuture((Object)this.data));
        Function<WriteQueryData, Statement> queryDataToStatement = new Function<WriteQueryData, Statement>(){

            public Statement apply(WriteQueryData queryData) {
                return WriteQueryDataImpl.toStatement(queryData, WriteQuery.this.getContext());
            }
        };
        return Futures.transform(queryDataFuture, (Function)queryDataToStatement);
    }

    private ListenableFuture<WriteQueryData> executeRequestInterceptorsAsync(ListenableFuture<WriteQueryData> queryDataFuture) {
        UnmodifiableIterator unmodifiableIterator = this.getContext().getInterceptorRegistry().getInterceptors(WriteQueryRequestInterceptor.class).reverse().iterator();
        while (unmodifiableIterator.hasNext()) {
            WriteQueryRequestInterceptor interceptor;
            final WriteQueryRequestInterceptor icptor = interceptor = (WriteQueryRequestInterceptor)unmodifiableIterator.next();
            Function<WriteQueryData, ListenableFuture<WriteQueryData>> mapperFunction = new Function<WriteQueryData, ListenableFuture<WriteQueryData>>(){

                public ListenableFuture<WriteQueryData> apply(WriteQueryData queryData) {
                    return icptor.onWriteRequestAsync(queryData);
                }
            };
            queryDataFuture = ListenableFutures.transform(queryDataFuture, mapperFunction, this.getContext().getTaskExecutor());
        }
        return queryDataFuture;
    }
}

