/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Update;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.oneandone.troilus.Context;
import net.oneandone.troilus.java7.interceptor.WriteQueryData;

class WriteQueryDataImpl
implements WriteQueryData {
    private final ImmutableMap<String, Object> keys;
    private final ImmutableList<Clause> whereConditions;
    private final ImmutableMap<String, Optional<Object>> valuesToMutate;
    private final ImmutableMap<String, ImmutableSet<Object>> setValuesToAdd;
    private final ImmutableMap<String, ImmutableSet<Object>> setValuesToRemove;
    private final ImmutableMap<String, ImmutableList<Object>> listValuesToAppend;
    private final ImmutableMap<String, ImmutableList<Object>> listValuesToPrepend;
    private final ImmutableMap<String, ImmutableList<Object>> listValuesToRemove;
    private final ImmutableMap<String, ImmutableMap<Object, Optional<Object>>> mapValuesToMutate;
    private final ImmutableList<Clause> onlyIfConditions;
    private final Boolean ifNotExists;

    WriteQueryDataImpl() {
        this((ImmutableMap<String, Object>)ImmutableMap.of(), (ImmutableList<Clause>)ImmutableList.of(), (ImmutableMap<String, Optional<Object>>)ImmutableMap.of(), (ImmutableMap<String, ImmutableSet<Object>>)ImmutableMap.of(), (ImmutableMap<String, ImmutableSet<Object>>)ImmutableMap.of(), (ImmutableMap<String, ImmutableList<Object>>)ImmutableMap.of(), (ImmutableMap<String, ImmutableList<Object>>)ImmutableMap.of(), (ImmutableMap<String, ImmutableList<Object>>)ImmutableMap.of(), (ImmutableMap<String, ImmutableMap<Object, Optional<Object>>>)ImmutableMap.of(), (ImmutableList<Clause>)ImmutableList.of(), null);
    }

    private WriteQueryDataImpl(ImmutableMap<String, Object> keys, ImmutableList<Clause> whereConditions, ImmutableMap<String, Optional<Object>> valuesToMutate, ImmutableMap<String, ImmutableSet<Object>> setValuesToAdd, ImmutableMap<String, ImmutableSet<Object>> setValuesToRemove, ImmutableMap<String, ImmutableList<Object>> listValuesToAppend, ImmutableMap<String, ImmutableList<Object>> listValuesToPrepend, ImmutableMap<String, ImmutableList<Object>> listValuesToRemove, ImmutableMap<String, ImmutableMap<Object, Optional<Object>>> mapValuesToMutate, ImmutableList<Clause> onlyIfConditions, Boolean ifNotExists) {
        this.keys = keys;
        this.whereConditions = whereConditions;
        this.valuesToMutate = valuesToMutate;
        this.setValuesToAdd = setValuesToAdd;
        this.setValuesToRemove = setValuesToRemove;
        this.listValuesToAppend = listValuesToAppend;
        this.listValuesToPrepend = listValuesToPrepend;
        this.listValuesToRemove = listValuesToRemove;
        this.mapValuesToMutate = mapValuesToMutate;
        this.onlyIfConditions = onlyIfConditions;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public WriteQueryDataImpl keys(ImmutableMap<String, Object> keys) {
        return new WriteQueryDataImpl(keys, this.whereConditions, this.valuesToMutate, this.setValuesToAdd, this.setValuesToRemove, this.listValuesToAppend, this.listValuesToPrepend, this.listValuesToRemove, this.mapValuesToMutate, this.onlyIfConditions, this.ifNotExists);
    }

    @Override
    public WriteQueryDataImpl whereConditions(ImmutableList<Clause> whereConditions) {
        return new WriteQueryDataImpl(this.keys, whereConditions, this.valuesToMutate, this.setValuesToAdd, this.setValuesToRemove, this.listValuesToAppend, this.listValuesToPrepend, this.listValuesToRemove, this.mapValuesToMutate, this.onlyIfConditions, this.ifNotExists);
    }

    @Override
    public WriteQueryDataImpl valuesToMutate(ImmutableMap<String, Optional<Object>> valuesToMutate) {
        return new WriteQueryDataImpl(this.keys, this.whereConditions, valuesToMutate, this.setValuesToAdd, this.setValuesToRemove, this.listValuesToAppend, this.listValuesToPrepend, this.listValuesToRemove, this.mapValuesToMutate, this.onlyIfConditions, this.ifNotExists);
    }

    @Override
    public WriteQueryDataImpl setValuesToAdd(ImmutableMap<String, ImmutableSet<Object>> setValuesToAdd) {
        return new WriteQueryDataImpl(this.keys, this.whereConditions, this.valuesToMutate, setValuesToAdd, this.setValuesToRemove, this.listValuesToAppend, this.listValuesToPrepend, this.listValuesToRemove, this.mapValuesToMutate, this.onlyIfConditions, this.ifNotExists);
    }

    @Override
    public WriteQueryDataImpl setValuesToRemove(ImmutableMap<String, ImmutableSet<Object>> setValuesToRemove) {
        return new WriteQueryDataImpl(this.keys, this.whereConditions, this.valuesToMutate, this.setValuesToAdd, setValuesToRemove, this.listValuesToAppend, this.listValuesToPrepend, this.listValuesToRemove, this.mapValuesToMutate, this.onlyIfConditions, this.ifNotExists);
    }

    @Override
    public WriteQueryDataImpl listValuesToAppend(ImmutableMap<String, ImmutableList<Object>> listValuesToAppend) {
        return new WriteQueryDataImpl(this.keys, this.whereConditions, this.valuesToMutate, this.setValuesToAdd, this.setValuesToRemove, listValuesToAppend, this.listValuesToPrepend, this.listValuesToRemove, this.mapValuesToMutate, this.onlyIfConditions, this.ifNotExists);
    }

    @Override
    public WriteQueryDataImpl listValuesToPrepend(ImmutableMap<String, ImmutableList<Object>> listValuesToPrepend) {
        return new WriteQueryDataImpl(this.keys, this.whereConditions, this.valuesToMutate, this.setValuesToAdd, this.setValuesToRemove, this.listValuesToAppend, listValuesToPrepend, this.listValuesToRemove, this.mapValuesToMutate, this.onlyIfConditions, this.ifNotExists);
    }

    @Override
    public WriteQueryDataImpl listValuesToRemove(ImmutableMap<String, ImmutableList<Object>> listValuesToRemove) {
        return new WriteQueryDataImpl(this.keys, this.whereConditions, this.valuesToMutate, this.setValuesToAdd, this.setValuesToRemove, this.listValuesToAppend, this.listValuesToPrepend, listValuesToRemove, this.mapValuesToMutate, this.onlyIfConditions, this.ifNotExists);
    }

    @Override
    public WriteQueryDataImpl mapValuesToMutate(ImmutableMap<String, ImmutableMap<Object, Optional<Object>>> mapValuesToMutate) {
        return new WriteQueryDataImpl(this.keys, this.whereConditions, this.valuesToMutate, this.setValuesToAdd, this.setValuesToRemove, this.listValuesToAppend, this.listValuesToPrepend, this.listValuesToRemove, mapValuesToMutate, this.onlyIfConditions, this.ifNotExists);
    }

    @Override
    public WriteQueryDataImpl onlyIfConditions(ImmutableList<Clause> onlyIfConditions) {
        return new WriteQueryDataImpl(this.keys, this.whereConditions, this.valuesToMutate, this.setValuesToAdd, this.setValuesToRemove, this.listValuesToAppend, this.listValuesToPrepend, this.listValuesToRemove, this.mapValuesToMutate, onlyIfConditions, this.ifNotExists);
    }

    @Override
    public WriteQueryDataImpl ifNotExists(Boolean ifNotExists) {
        return new WriteQueryDataImpl(this.keys, this.whereConditions, this.valuesToMutate, this.setValuesToAdd, this.setValuesToRemove, this.listValuesToAppend, this.listValuesToPrepend, this.listValuesToRemove, this.mapValuesToMutate, this.onlyIfConditions, ifNotExists);
    }

    @Override
    public ImmutableMap<String, Object> getKeys() {
        return this.keys;
    }

    @Override
    public ImmutableList<Clause> getWhereConditions() {
        return this.whereConditions;
    }

    @Override
    public ImmutableMap<String, Optional<Object>> getValuesToMutate() {
        return this.valuesToMutate;
    }

    @Override
    public ImmutableMap<String, ImmutableSet<Object>> getSetValuesToAdd() {
        return this.setValuesToAdd;
    }

    @Override
    public ImmutableMap<String, ImmutableSet<Object>> getSetValuesToRemove() {
        return this.setValuesToRemove;
    }

    @Override
    public ImmutableMap<String, ImmutableList<Object>> getListValuesToAppend() {
        return this.listValuesToAppend;
    }

    @Override
    public ImmutableMap<String, ImmutableList<Object>> getListValuesToPrepend() {
        return this.listValuesToPrepend;
    }

    @Override
    public ImmutableMap<String, ImmutableList<Object>> getListValuesToRemove() {
        return this.listValuesToRemove;
    }

    @Override
    public ImmutableMap<String, ImmutableMap<Object, Optional<Object>>> getMapValuesToMutate() {
        return this.mapValuesToMutate;
    }

    @Override
    public ImmutableList<Clause> getOnlyIfConditions() {
        return this.onlyIfConditions;
    }

    @Override
    public Boolean getIfNotExits() {
        return this.ifNotExists;
    }

    static Statement toStatement(WriteQueryData data, Context ctx) {
        if (data.getIfNotExits() != null || data.getKeys().isEmpty() && data.getWhereConditions().isEmpty()) {
            return WriteQueryDataImpl.toInsertStatement(data, ctx);
        }
        return WriteQueryDataImpl.toUpdateStatement(data, ctx);
    }

    private static Statement toInsertStatement(WriteQueryData data, Context ctx) {
        Insert insert = QueryBuilder.insertInto((String)ctx.getDbSession().getTablename());
        ArrayList values = Lists.newArrayList();
        for (Map.Entry entry : data.getValuesToMutate().entrySet()) {
            insert.value((String)entry.getKey(), (Object)QueryBuilder.bindMarker());
            values.add(ctx.toStatementValue((String)entry.getKey(), ((Optional)entry.getValue()).orNull()));
        }
        if (data.getIfNotExits() != null) {
            insert.ifNotExists();
            if (ctx.getSerialConsistencyLevel() != null) {
                insert.setSerialConsistencyLevel(ctx.getSerialConsistencyLevel());
            }
        }
        if (ctx.getTtlSec() != null) {
            insert.using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker()));
            values.add(ctx.getTtlSec());
        }
        PreparedStatement stmt = ctx.getDbSession().prepare((BuiltStatement)insert);
        return stmt.bind(values.toArray());
    }

    private static Statement toUpdateStatement(WriteQueryData data, Context ctx) {
        Update update = QueryBuilder.update((String)ctx.getDbSession().getTablename());
        for (Clause onlyIfCondition : data.getOnlyIfConditions()) {
            update.onlyIf(onlyIfCondition);
        }
        if (data.getWhereConditions().isEmpty()) {
            ArrayList values = Lists.newArrayList();
            for (Map.Entry entry : data.getValuesToMutate().entrySet()) {
                update.with(QueryBuilder.set((String)((String)entry.getKey()), (Object)QueryBuilder.bindMarker()));
                values.add(WriteQueryDataImpl.toStatementValue(ctx, (String)entry.getKey(), ((Optional)entry.getValue()).orNull()));
            }
            for (Map.Entry entry : data.getSetValuesToAdd().entrySet()) {
                update.with(QueryBuilder.addAll((String)((String)entry.getKey()), (BindMarker)QueryBuilder.bindMarker()));
                values.add(WriteQueryDataImpl.toStatementValue(ctx, (String)entry.getKey(), (ImmutableSet<Object>)((ImmutableSet)entry.getValue())));
            }
            for (Map.Entry entry : data.getSetValuesToRemove().entrySet()) {
                update.with(QueryBuilder.removeAll((String)((String)entry.getKey()), (BindMarker)QueryBuilder.bindMarker()));
                values.add(WriteQueryDataImpl.toStatementValue(ctx, (String)entry.getKey(), (ImmutableSet<Object>)((ImmutableSet)entry.getValue())));
            }
            for (Map.Entry entry : data.getListValuesToPrepend().entrySet()) {
                update.with(QueryBuilder.prependAll((String)((String)entry.getKey()), (BindMarker)QueryBuilder.bindMarker()));
                values.add(WriteQueryDataImpl.toStatementValue(ctx, (String)entry.getKey(), (ImmutableList<Object>)((ImmutableList)entry.getValue())));
            }
            for (Map.Entry entry : data.getListValuesToAppend().entrySet()) {
                update.with(QueryBuilder.appendAll((String)((String)entry.getKey()), (BindMarker)QueryBuilder.bindMarker()));
                values.add(WriteQueryDataImpl.toStatementValue(ctx, (String)entry.getKey(), (ImmutableList<Object>)((ImmutableList)entry.getValue())));
            }
            for (Map.Entry entry : data.getListValuesToRemove().entrySet()) {
                update.with(QueryBuilder.discardAll((String)((String)entry.getKey()), (BindMarker)QueryBuilder.bindMarker()));
                values.add(WriteQueryDataImpl.toStatementValue(ctx, (String)entry.getKey(), (ImmutableList<Object>)((ImmutableList)entry.getValue())));
            }
            for (Map.Entry entry : data.getMapValuesToMutate().entrySet()) {
                update.with(QueryBuilder.putAll((String)((String)entry.getKey()), (BindMarker)QueryBuilder.bindMarker()));
                values.add(WriteQueryDataImpl.toStatementValue(ctx, (String)entry.getKey(), (ImmutableMap<Object, Optional<Object>>)((ImmutableMap)entry.getValue())));
            }
            for (Map.Entry entry : data.getKeys().entrySet()) {
                update.where(QueryBuilder.eq((String)((String)entry.getKey()), (Object)QueryBuilder.bindMarker()));
                values.add(WriteQueryDataImpl.toStatementValue(ctx, (String)entry.getKey(), entry.getValue()));
            }
            if (ctx.getTtlSec() != null) {
                update.using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker()));
                values.add(ctx.getTtlSec());
            }
            return ctx.getDbSession().prepare((BuiltStatement)update).bind(values.toArray());
        }
        for (Map.Entry entry : data.getValuesToMutate().entrySet()) {
            update.with(QueryBuilder.set((String)((String)entry.getKey()), (Object)WriteQueryDataImpl.toStatementValue(ctx, (String)entry.getKey(), ((Optional)entry.getValue()).orNull())));
        }
        for (Map.Entry entry : data.getSetValuesToAdd().entrySet()) {
            update.with(QueryBuilder.addAll((String)((String)entry.getKey()), WriteQueryDataImpl.toStatementValue(ctx, (String)entry.getKey(), (ImmutableSet<Object>)((ImmutableSet)entry.getValue()))));
        }
        for (Map.Entry entry : data.getSetValuesToRemove().entrySet()) {
            update.with(QueryBuilder.removeAll((String)((String)entry.getKey()), WriteQueryDataImpl.toStatementValue(ctx, (String)entry.getKey(), (ImmutableSet<Object>)((ImmutableSet)entry.getValue()))));
        }
        for (Map.Entry entry : data.getListValuesToPrepend().entrySet()) {
            update.with(QueryBuilder.prependAll((String)((String)entry.getKey()), WriteQueryDataImpl.toStatementValue(ctx, (String)entry.getKey(), (ImmutableList<Object>)((ImmutableList)entry.getValue()))));
        }
        for (Map.Entry entry : data.getListValuesToAppend().entrySet()) {
            update.with(QueryBuilder.appendAll((String)((String)entry.getKey()), WriteQueryDataImpl.toStatementValue(ctx, (String)entry.getKey(), (ImmutableList<Object>)((ImmutableList)entry.getValue()))));
        }
        for (Map.Entry entry : data.getListValuesToRemove().entrySet()) {
            update.with(QueryBuilder.discardAll((String)((String)entry.getKey()), WriteQueryDataImpl.toStatementValue(ctx, (String)entry.getKey(), (ImmutableList<Object>)((ImmutableList)entry.getValue()))));
        }
        for (Map.Entry entry : data.getMapValuesToMutate().entrySet()) {
            update.with(QueryBuilder.putAll((String)((String)entry.getKey()), WriteQueryDataImpl.toStatementValue(ctx, (String)entry.getKey(), (ImmutableMap<Object, Optional<Object>>)((ImmutableMap)entry.getValue()))));
        }
        if (ctx.getTtlSec() != null) {
            update.using(QueryBuilder.ttl((int)ctx.getTtlSec()));
        }
        for (Clause whereCondition : data.getWhereConditions()) {
            update.where(whereCondition);
        }
        return update;
    }

    private static Object toStatementValue(Context ctx, String name, Object value) {
        return ctx.toStatementValue(name, value);
    }

    private static ImmutableSet<Object> toStatementValue(Context ctx, String name, ImmutableSet<Object> values) {
        return ImmutableSet.copyOf(WriteQueryDataImpl.toStatementValue(ctx, name, (ImmutableList<Object>)ImmutableList.copyOf(values)));
    }

    private static ImmutableList<Object> toStatementValue(Context ctx, String name, ImmutableList<Object> values) {
        ArrayList result = Lists.newArrayList();
        for (Object value : values) {
            result.add(WriteQueryDataImpl.toStatementValue(ctx, name, value));
        }
        return ImmutableList.copyOf((Collection)result);
    }

    private static Map<Object, Object> toStatementValue(Context ctx, String name, ImmutableMap<Object, Optional<Object>> map) {
        HashMap m = Maps.newHashMap();
        for (Map.Entry entry : map.entrySet()) {
            m.put(WriteQueryDataImpl.toStatementValue(ctx, name, WriteQueryDataImpl.toStatementValue(ctx, name, entry.getKey())), WriteQueryDataImpl.toStatementValue(ctx, name, ((Optional)entry.getValue()).orNull()));
        }
        return m;
    }
}

