/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.troilus.interceptor;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.HashSet;
import net.oneandone.troilus.ColumnName;
import net.oneandone.troilus.ConstraintException;
import net.oneandone.troilus.java7.interceptor.WriteQueryData;
import net.oneandone.troilus.java7.interceptor.WriteQueryRequestInterceptor;

public class ConstraintsInterceptor
implements WriteQueryRequestInterceptor {
    private final ImmutableSet<String> notNullColumns;
    private final ImmutableSet<String> immutableColumns;

    private ConstraintsInterceptor(ImmutableSet<String> notNullColumns, ImmutableSet<String> immutableColumns) {
        this.notNullColumns = notNullColumns;
        this.immutableColumns = immutableColumns;
    }

    public static ConstraintsInterceptor newConstraints() {
        return new ConstraintsInterceptor((ImmutableSet<String>)ImmutableSet.of(), (ImmutableSet<String>)ImmutableSet.of());
    }

    public ConstraintsInterceptor withNotNullColumn(ColumnName<?> columnName) {
        return this.withNotNullColumn(columnName.getName());
    }

    public ConstraintsInterceptor withNotNullColumn(String columnName) {
        return new ConstraintsInterceptor((ImmutableSet<String>)ImmutableSet.builder().addAll(this.notNullColumns).add((Object)columnName).build(), this.immutableColumns);
    }

    public ConstraintsInterceptor withImmutableColumn(ColumnName<?> columnName) {
        return this.withImmutableColumn(columnName.getName());
    }

    public ConstraintsInterceptor withImmutableColumn(String columnName) {
        return new ConstraintsInterceptor(this.notNullColumns, (ImmutableSet<String>)ImmutableSet.builder().addAll(this.immutableColumns).add((Object)columnName).build());
    }

    @Override
    public ListenableFuture<WriteQueryData> onWriteRequestAsync(WriteQueryData queryData) throws ConstraintException {
        this.checkNotNullColumn(queryData);
        this.checkImmutableColumn(queryData);
        return Futures.immediateFuture((Object)queryData);
    }

    private void checkNotNullColumn(WriteQueryData queryData) {
        if (this.isInsert(queryData)) {
            HashSet missingColumns = Sets.newHashSet(this.notNullColumns);
            missingColumns.removeAll((Collection<?>)queryData.getKeys().keySet());
            for (String column : Sets.newHashSet((Iterable)missingColumns)) {
                if (queryData.getValuesToMutate().get((Object)column) == null || !((Optional)queryData.getValuesToMutate().get((Object)column)).isPresent()) continue;
                missingColumns.remove(column);
            }
            if (!missingColumns.isEmpty()) {
                throw new ConstraintException("NOT NULL column(s) " + Joiner.on((String)", ").join((Iterable)missingColumns) + " has to be set");
            }
        } else {
            for (String notNullColumn : this.notNullColumns) {
                if (!queryData.getValuesToMutate().containsKey((Object)notNullColumn) || queryData.getValuesToMutate().get((Object)notNullColumn) == null || ((Optional)queryData.getValuesToMutate().get((Object)notNullColumn)).isPresent()) continue;
                throw new ConstraintException("NOT NULL column " + notNullColumn + " can not be set with NULL");
            }
        }
    }

    private void checkImmutableColumn(WriteQueryData queryData) {
        if (!this.isInsert(queryData)) {
            for (String immutableColumn : this.immutableColumns) {
                if (!queryData.getValuesToMutate().containsKey((Object)immutableColumn) || queryData.getValuesToMutate().get((Object)immutableColumn) == null || !((Optional)queryData.getValuesToMutate().get((Object)immutableColumn)).isPresent()) continue;
                throw new ConstraintException("immutable column " + immutableColumn + " can not be updated (column can be set within ifNotExists() write query only)");
            }
        }
    }

    private boolean isInsert(WriteQueryData queryData) {
        return queryData.getIfNotExits() != null && queryData.getIfNotExits() != false;
    }
}

