/*
 * Decompiled with CFR 0.152.
 */
package lombok.core.handlers;

import java.util.List;
import lombok.ast.AST;
import lombok.ast.Expression;
import lombok.ast.FieldDecl;
import lombok.ast.IMethod;
import lombok.ast.IType;
import lombok.ast.MethodDecl;
import lombok.ast.TypeRef;
import lombok.core.util.Names;

public abstract class AbstractArtemisHandler<COMPILER_BINDING, TYPE_TYPE extends IType<METHOD_TYPE, ?, ?, ?, ?, ?>, METHOD_TYPE extends IMethod<TYPE_TYPE, ?, ?, ?>> {
    private final TYPE_TYPE type;

    public AbstractArtemisHandler(TYPE_TYPE type) {
        this.type = type;
    }

    public AbstractArtemisHandler<COMPILER_BINDING, TYPE_TYPE, METHOD_TYPE> handle(List<Object> mappedComponentTypes, List<Object> systemTypes, List<Object> managerTypes) {
        for (Object component : mappedComponentTypes) {
            this.type.editor().injectField(this.createMapperField(this.getBinding(this.type, component)));
        }
        for (Object system : systemTypes) {
            this.type.editor().injectField(this.createField(this.getBinding(this.type, system)));
        }
        for (Object manager : managerTypes) {
            this.type.editor().injectField(this.createField(this.getBinding(this.type, manager)));
        }
        return this;
    }

    public AbstractArtemisHandler<COMPILER_BINDING, TYPE_TYPE, METHOD_TYPE> rebuild() {
        this.type.editor().rebuild();
        return this;
    }

    public AbstractArtemisHandler<COMPILER_BINDING, TYPE_TYPE, METHOD_TYPE> injectInitialize() {
        this.type.editor().injectMethod((MethodDecl)((MethodDecl)AST.MethodDecl((TypeRef)AST.Type(Void.TYPE), (String)"initialize").withArgument(AST.Arg((TypeRef)AST.Type((String)"com.artemis.World"), (String)"world"))).makePublic());
        return this;
    }

    private FieldDecl createField(COMPILER_BINDING type) {
        String name = this.toFieldName(type);
        return AST.FieldDecl((TypeRef)AST.Type((String)this.toQualifiedName(type)), (String)name).makePrivate();
    }

    private FieldDecl createMapperField(COMPILER_BINDING componentType) {
        String name = Names.decapitalize((String)this.toFieldName(componentType)) + "Mapper";
        return ((FieldDecl)AST.FieldDecl((TypeRef)AST.Type((String)"com.artemis.ComponentMapper").withTypeArgument(AST.Type((String)this.toQualifiedName(componentType))), (String)name).withAnnotation(AST.Annotation((TypeRef)AST.Type(SuppressWarnings.class)).withValue((Expression)AST.String((String)"all")))).makePrivate();
    }

    protected abstract COMPILER_BINDING getBinding(TYPE_TYPE var1, Object var2);

    protected abstract String toFieldName(COMPILER_BINDING var1);

    protected abstract String toQualifiedName(COMPILER_BINDING var1);
}

