/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.io;

import com.artemis.Component;
import com.artemis.ComponentMapper;
import com.artemis.Entity;
import com.artemis.EntityEdit;
import com.artemis.FakeEntityFactory;
import com.artemis.World;
import com.artemis.annotations.SkipWire;
import com.artemis.annotations.Wire;
import com.artemis.components.SerializationTag;
import com.artemis.io.ArchetypeMapper;
import com.artemis.io.ComponentNameComparator;
import com.artemis.io.DefaultObjectStore;
import com.artemis.io.EntityPoolFactory;
import com.artemis.io.ReferenceTracker;
import com.artemis.io.SaveFileFormat;
import com.artemis.io.SerializationKeyTracker;
import com.artemis.managers.GroupManager;
import com.artemis.managers.TagManager;
import com.artemis.utils.Bag;
import com.artemis.utils.ImmutableBag;
import com.esotericsoftware.jsonbeans.Json;
import com.esotericsoftware.jsonbeans.JsonSerializer;
import com.esotericsoftware.jsonbeans.JsonValue;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

@Wire(failOnNull=false)
public class EntitySerializer
implements JsonSerializer<Entity> {
    private final Bag<Component> components = new Bag();
    private final ComponentNameComparator comparator = new ComponentNameComparator();
    @SkipWire
    private final World world;
    private final ReferenceTracker referenceTracker;
    private final DefaultObjectStore defaultValues;
    final EntityPoolFactory factory;
    private GroupManager groupManager;
    private TagManager tagManager;
    private final Collection<String> registeredTags;
    private boolean isSerializingEntity;
    private ComponentMapper<SerializationTag> saveTagMapper;
    SerializationKeyTracker keyTracker;
    ArchetypeMapper archetypeMapper;
    SaveFileFormat serializationState;
    private int archetype = -1;

    public EntitySerializer(World world, ReferenceTracker referenceTracker) {
        this.world = world;
        this.referenceTracker = referenceTracker;
        this.defaultValues = new DefaultObjectStore();
        this.factory = new EntityPoolFactory(world);
        world.inject((Object)this);
        this.registeredTags = this.tagManager != null ? this.tagManager.getRegisteredTags() : Collections.emptyList();
    }

    void setUsePrototypes(boolean usePrototypes) {
        this.defaultValues.setUsePrototypes(usePrototypes);
    }

    void preLoad() {
        this.keyTracker = new SerializationKeyTracker();
    }

    public void write(Json json, Entity e, Class knownType) {
        if (this.isSerializingEntity) {
            json.writeValue((Object)e.getId());
            return;
        }
        this.isSerializingEntity = true;
        this.world.getComponentManager().getComponentsFor(e.getId(), this.components);
        this.components.sort((Comparator)this.comparator);
        json.writeObjectStart();
        this.writeArchetype(json, e);
        this.writeTag(json, e);
        this.writeKeyTag(json, e);
        this.writeGroups(json, e);
        json.writeObjectStart("components");
        SaveFileFormat.ComponentIdentifiers identifiers = this.serializationState.componentIdentifiers;
        Map typeToName = identifiers.typeToName;
        int s = this.components.size();
        for (int i = 0; s > i; ++i) {
            Component c = (Component)this.components.get(i);
            if (identifiers.isTransient(c.getClass()) || this.defaultValues.hasDefaultValues((Object)c)) continue;
            String componentIdentifier = (String)typeToName.get(c.getClass());
            json.writeObjectStart(componentIdentifier);
            json.writeFields((Object)c);
            json.writeObjectEnd();
        }
        json.writeObjectEnd();
        json.writeObjectEnd();
        this.components.clear();
        this.isSerializingEntity = false;
    }

    private void writeArchetype(Json json, Entity e) {
        json.writeValue("archetype", (Object)e.getCompositionId());
    }

    private void writeTag(Json json, Entity e) {
        for (String tag : this.registeredTags) {
            if (this.tagManager.getEntity(tag) != e) continue;
            json.writeValue("tag", (Object)tag);
            break;
        }
    }

    private void writeKeyTag(Json json, Entity e) {
        String key;
        if (this.saveTagMapper.has(e) && (key = ((SerializationTag)this.saveTagMapper.get((Entity)e)).tag) != null) {
            json.writeValue("key", (Object)key);
        }
    }

    private void writeGroups(Json json, Entity e) {
        if (this.groupManager == null) {
            return;
        }
        ImmutableBag groups = this.groupManager.getGroups(e);
        if (groups.size() == 0) {
            return;
        }
        json.writeArrayStart("groups");
        for (String group : groups) {
            json.writeValue((Object)group);
        }
        json.writeArrayEnd();
    }

    public Entity read(Json json, JsonValue jsonData, Class type) {
        if (this.isSerializingEntity) {
            int entityId = (Integer)json.readValue(Integer.class, jsonData);
            return FakeEntityFactory.create((World)this.world, (int)entityId);
        }
        this.isSerializingEntity = true;
        Entity e = this.factory.createEntity();
        jsonData = this.readArchetype(jsonData, e);
        jsonData = this.readTag(jsonData, e);
        jsonData = this.readKeyTag(jsonData, e);
        if (!"components".equals((jsonData = this.readGroups(jsonData, e)).name())) {
            jsonData = jsonData.child;
        }
        assert ("components".equals(jsonData.name));
        JsonValue component = jsonData.child;
        if (this.archetype != -1) {
            this.readComponentsArchetype(json, e, component);
        } else {
            this.readComponentsEdit(json, e, component);
        }
        this.isSerializingEntity = false;
        return e;
    }

    private void readComponentsArchetype(Json json, Entity e, JsonValue component) {
        SaveFileFormat.ComponentIdentifiers identifiers = this.serializationState.componentIdentifiers;
        this.archetypeMapper.transmute(e, this.archetype);
        while (component != null) {
            assert (component.name() != null);
            Class componentType = identifiers.getType(component.name);
            this.readComponent(json, component, e.getComponent(componentType));
            component = component.next;
        }
    }

    private void readComponentsEdit(Json json, Entity e, JsonValue component) {
        SaveFileFormat.ComponentIdentifiers identifiers = this.serializationState.componentIdentifiers;
        EntityEdit edit = e.edit();
        while (component != null) {
            assert (component.name() != null);
            Class componentType = identifiers.getType(component.name);
            this.readComponent(json, component, edit.create(componentType));
            component = component.next;
        }
    }

    private void readComponent(Json json, JsonValue component, Component c) {
        json.readFields((Object)c, component);
        this.referenceTracker.addEntityReferencingComponent(c);
    }

    private JsonValue readGroups(JsonValue jsonData, Entity e) {
        if ("groups".equals(jsonData.name)) {
            JsonValue group = jsonData.child;
            while (group != null) {
                this.groupManager.add(e, group.asString());
                group = group.next;
            }
            jsonData = jsonData.next;
        }
        return jsonData;
    }

    private JsonValue readArchetype(JsonValue jsonData, Entity e) {
        if ("archetype".equals(jsonData.name)) {
            this.archetype = jsonData.asInt();
            jsonData = jsonData.next;
        } else {
            this.archetype = -1;
        }
        return jsonData;
    }

    private JsonValue readTag(JsonValue jsonData, Entity e) {
        if ("tag".equals(jsonData.name)) {
            this.tagManager.register(jsonData.asString(), e);
            jsonData = jsonData.next;
        }
        return jsonData;
    }

    private JsonValue readKeyTag(JsonValue jsonData, Entity e) {
        if ("key".equals(jsonData.name)) {
            String key = jsonData.asString();
            this.keyTracker.register(key, e);
            ((SerializationTag)this.saveTagMapper.create((Entity)e)).tag = key;
            jsonData = jsonData.next;
        }
        return jsonData;
    }
}

