/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.io;

import com.artemis.ComponentCollector;
import com.artemis.Entity;
import com.artemis.World;
import com.artemis.io.ArchetypeMapper;
import com.artemis.io.ArchetypeMapperSerializer;
import com.artemis.io.ComponentLookupSerializer;
import com.artemis.io.EntityBagSerializer;
import com.artemis.io.EntitySerializer;
import com.artemis.io.IntBagEntitySerializer;
import com.artemis.io.ReferenceTracker;
import com.artemis.io.SaveFileFormat;
import com.artemis.io.SerializationException;
import com.artemis.io.TransmuterEntrySerializer;
import com.artemis.managers.WorldSerializationManager;
import com.artemis.utils.Bag;
import com.artemis.utils.IntBag;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.Constructor;
import com.artemis.utils.reflect.ReflectionException;
import com.esotericsoftware.jsonbeans.Json;
import com.esotericsoftware.jsonbeans.JsonReader;
import com.esotericsoftware.jsonbeans.JsonSerializer;
import com.esotericsoftware.jsonbeans.JsonValue;
import com.esotericsoftware.jsonbeans.OutputType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class JsonArtemisSerializer
extends WorldSerializationManager.ArtemisSerializer<JsonSerializer> {
    private final Json json;
    private final ComponentLookupSerializer lookup;
    private final IntBagEntitySerializer intBagEntitySerializer;
    private final TransmuterEntrySerializer transmuterEntrySerializer;
    private final EntitySerializer entitySerializer;
    private final ComponentCollector componentCollector;
    private boolean prettyPrint;
    private ReferenceTracker referenceTracker;

    public JsonArtemisSerializer(World world) {
        super(world);
        this.componentCollector = new ComponentCollector(world);
        this.referenceTracker = new ReferenceTracker(world);
        this.lookup = new ComponentLookupSerializer();
        this.intBagEntitySerializer = new IntBagEntitySerializer(world);
        this.entitySerializer = new EntitySerializer(world, this.referenceTracker);
        this.transmuterEntrySerializer = new TransmuterEntrySerializer();
        this.json = new Json(OutputType.json);
        this.json.setIgnoreUnknownFields(true);
        this.json.setSerializer(SaveFileFormat.ComponentIdentifiers.class, (JsonSerializer)this.lookup);
        this.json.setSerializer(Bag.class, (JsonSerializer)new EntityBagSerializer(world));
        this.json.setSerializer(IntBag.class, (JsonSerializer)this.intBagEntitySerializer);
        this.json.setSerializer(Entity.class, (JsonSerializer)this.entitySerializer);
        this.json.setSerializer(ArchetypeMapper.class, (JsonSerializer)new ArchetypeMapperSerializer());
        this.json.setSerializer(ArchetypeMapper.TransmuterEntry.class, (JsonSerializer)this.transmuterEntrySerializer);
    }

    public JsonArtemisSerializer prettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    public JsonArtemisSerializer setUsePrototypes(boolean usePrototypes) {
        this.json.setUsePrototypes(usePrototypes);
        this.entitySerializer.setUsePrototypes(usePrototypes);
        return this;
    }

    public WorldSerializationManager.ArtemisSerializer register(Class<?> type, JsonSerializer serializer) {
        this.json.setSerializer(type, serializer);
        return this;
    }

    public void save(Writer writer, SaveFileFormat save) {
        try {
            this.referenceTracker.inspectTypes(this.world);
            this.referenceTracker.preWrite(save);
            save.archetypes = new ArchetypeMapper(this.world, save.entities);
            this.componentCollector.preWrite(save);
            this.entitySerializer.serializationState = save;
            this.transmuterEntrySerializer.identifiers = save.componentIdentifiers;
            this.entitySerializer.archetypeMapper = new ArchetypeMapper(this.world, save.entities);
            this.entitySerializer.archetypeMapper.serializationState = save;
            save.componentIdentifiers.build();
            if (this.prettyPrint) {
                writer.append(this.json.prettyPrint((Object)save));
                writer.flush();
            } else {
                this.json.toJson((Object)save, writer);
            }
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    protected void save(OutputStream out, SaveFileFormat save) {
        this.save(new OutputStreamWriter(out), save);
    }

    protected <T extends SaveFileFormat> T load(InputStream is, Class<T> format) {
        return this.load(new JsonReader().parse(is), format);
    }

    public <T extends SaveFileFormat> T load(JsonValue jsonData, Class<T> format) {
        this.entitySerializer.preLoad();
        SaveFileFormat partial = this.partialLoad(jsonData);
        this.referenceTracker.inspectTypes(partial.componentIdentifiers.getTypes());
        this.entitySerializer.factory.configureWith(this.countChildren(jsonData.get("entities")));
        T t = this.newInstance(format);
        this.json.readFields(t, jsonData);
        ((SaveFileFormat)t).tracker = this.entitySerializer.keyTracker;
        this.referenceTracker.translate(this.intBagEntitySerializer.getTranslatedIds());
        return t;
    }

    private <T extends SaveFileFormat> T newInstance(Class<T> format) {
        if (format.getClass().equals(SaveFileFormat.class)) {
            return (T)new SaveFileFormat();
        }
        try {
            Constructor ctor = ClassReflection.getDeclaredConstructor(format, (Class[])new Class[0]);
            ctor.setAccessible(true);
            return (T)((SaveFileFormat)ctor.newInstance(new Object[0]));
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    private SaveFileFormat partialLoad(JsonValue jsonMap) {
        SaveFileFormat save = new SaveFileFormat((IntBag)null);
        this.json.readField((Object)save, "componentIdentifiers", jsonMap);
        this.transmuterEntrySerializer.identifiers = save.componentIdentifiers;
        this.json.readField((Object)save, "archetypes", jsonMap);
        this.entitySerializer.archetypeMapper = save.archetypes;
        this.entitySerializer.serializationState = save;
        if (this.entitySerializer.archetypeMapper != null) {
            this.entitySerializer.archetypeMapper.serializationState = save;
            this.transmuterEntrySerializer.identifiers = save.componentIdentifiers;
        }
        return save;
    }

    private int countChildren(JsonValue jsonData) {
        if (jsonData == null || jsonData.child == null) {
            return 0;
        }
        JsonValue entity = jsonData.child;
        int count = 0;
        while (entity != null) {
            ++count;
            entity = entity.next;
        }
        return count;
    }
}

