/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Component;
import com.artemis.ComponentManager;
import com.artemis.World;
import com.artemis.io.SaveFileFormat;
import com.artemis.utils.BitVector;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ComponentCollector {
    private BitVector componentIds = new BitVector();
    private Set<Class<Component>> referencedComponents = new HashSet<Class<Component>>();
    private World world;

    public ComponentCollector(World world) {
        this.world = world;
    }

    public void preWrite(SaveFileFormat save) {
        this.componentIds.clear();
        this.referencedComponents.clear();
        this.inspectComponentTypes(save);
        this.extractComponents(save);
    }

    protected void extractComponents(SaveFileFormat save) {
        ComponentManager cm = this.world.getComponentManager();
        Map<Class<? extends Component>, String> lookup = save.componentIdentifiers.typeToName;
        HashSet<String> names = new HashSet<String>();
        BitVector bs = this.componentIds;
        SaveFileFormat.ComponentIdentifiers identifiers = save.componentIdentifiers;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            Class type = cm.typeFactory.getTypeFor(i).getType();
            lookup.put(type, this.resolveNameId(names, type));
            if (identifiers.typeToId.get(type) == null) {
                identifiers.typeToId.put(type, lookup.size());
                identifiers.idToType.put(lookup.size(), type);
            }
            i = bs.nextSetBit(i + 1);
        }
    }

    private String resolveNameId(Set<String> existing, Class<? extends Component> type) {
        String name = type.getSimpleName();
        if (existing.contains(name)) {
            int index = 2;
            while (existing.contains(name + "_" + index++)) {
            }
            name = name + "_" + (index - 1);
        }
        existing.add(name);
        return name;
    }

    protected void inspectComponentTypes(SaveFileFormat save) {
        ComponentManager cm = this.world.getComponentManager();
        int[] ids = save.entities.getData();
        int s = save.entities.size();
        for (int i = 0; s > i; ++i) {
            this.componentIds.or(cm.componentBits(ids[i]));
        }
    }
}

