/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.io;

import com.artemis.Component;
import com.artemis.Entity;
import com.artemis.EntityTransmuter;
import com.artemis.EntityTransmuterFactory;
import com.artemis.World;
import com.artemis.annotations.Transient;
import com.artemis.io.SaveFileFormat;
import com.artemis.utils.Bag;
import com.artemis.utils.IntBag;
import com.artemis.utils.reflect.ClassReflection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArchetypeMapper {
    public Map<Integer, TransmuterEntry> compositionIdMapper = new HashMap<Integer, TransmuterEntry>();
    public SaveFileFormat serializationState;

    public ArchetypeMapper(World world, IntBag toSave) {
        int[] ids = toSave.getData();
        Bag components = new Bag();
        Bag types = new Bag();
        int s = toSave.size();
        for (int i = 0; s > i; ++i) {
            int compositionId = world.getEntity(ids[i]).getCompositionId();
            if (this.compositionIdMapper.containsKey(compositionId)) continue;
            components.clear();
            types.clear();
            world.getComponentManager().getComponentsFor(ids[i], components);
            this.compositionIdMapper.put(compositionId, new TransmuterEntry(ArchetypeMapper.toClasses((Bag<Component>)components, (Bag<Class<? extends Component>>)types)));
        }
    }

    public ArchetypeMapper() {
    }

    private static Bag<Class<? extends Component>> toClasses(Bag<Component> source, Bag<Class<? extends Component>> target) {
        for (int i = 0; i < source.size(); ++i) {
            target.add(((Component)source.get(i)).getClass());
        }
        return target;
    }

    public void transmute(Entity e, int compositionId) {
        this.compositionIdMapper.get(compositionId).transmute(e);
    }

    public Iterable<? extends Map.Entry<Integer, TransmuterEntry>> entrySet() {
        return this.compositionIdMapper.entrySet();
    }

    public static class TransmuterEntry {
        public List<Class<? extends Component>> componentTypes = new ArrayList<Class<? extends Component>>();
        private transient EntityTransmuter transmuter;

        public TransmuterEntry(Bag<Class<? extends Component>> types) {
            for (Class c : types) {
                if (ClassReflection.getAnnotation((Class)c, Transient.class) != null) continue;
                this.componentTypes.add(c);
            }
        }

        public TransmuterEntry() {
        }

        public void transmute(Entity e) {
            if (this.transmuter == null) {
                EntityTransmuterFactory factory = new EntityTransmuterFactory(e.getWorld());
                int s = this.componentTypes.size();
                for (int i = 0; s > i; ++i) {
                    factory.add(this.componentTypes.get(i));
                }
                this.transmuter = factory.build();
            }
            this.transmuter.transmute(e);
        }
    }
}

