/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.io;

import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.Field;
import com.artemis.utils.reflect.ReflectionException;
import java.util.ArrayList;
import java.util.HashMap;

public class DefaultObjectStore {
    private HashMap<Class, TypeData> defaultValues = new HashMap();
    private boolean usePrototypes = true;

    public boolean hasDefaultValues(Object object) {
        if (!this.usePrototypes) {
            return false;
        }
        TypeData typeData = this.defaultValues.get(object.getClass());
        if (typeData == null) {
            typeData = new TypeData(this.newInstance(object.getClass()));
            this.defaultValues.put(object.getClass(), typeData);
        }
        return typeData.hasDefaultValues(object);
    }

    private Object newInstance(Class<?> type) {
        try {
            return ClassReflection.newInstance(type);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    public void setUsePrototypes(boolean usePrototypes) {
        this.usePrototypes = usePrototypes;
    }

    static class TypeData {
        private final Object object;
        private final Class type;
        private final Field[] fields;

        TypeData(Object object) {
            this.object = object;
            this.type = object.getClass();
            Field[] fields = ClassReflection.getDeclaredFields((Class)this.type);
            ArrayList<Field> filtered = new ArrayList<Field>();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                if (f.isStatic()) continue;
                f.setAccessible(true);
                filtered.add(f);
            }
            this.fields = filtered.toArray(new Field[0]);
        }

        boolean hasDefaultValues(Object other) {
            assert (other.getClass() == this.type);
            try {
                for (int i = 0; i < this.fields.length; ++i) {
                    Field f = this.fields[i];
                    if (TypeData.equals(f.get(this.object), f.get(other))) continue;
                    return false;
                }
                return true;
            }
            catch (ReflectionException e) {
                throw new RuntimeException(e);
            }
        }

        private static boolean equals(Object a, Object b) {
            return a != null ? a.equals(b) : b == null;
        }
    }
}

