/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.io;

import com.artemis.Archetype;
import com.artemis.ArchetypeBuilder;
import com.artemis.Entity;
import com.artemis.World;
import com.artemis.utils.IntBag;
import java.util.Arrays;

class EntityPoolFactory {
    private final Archetype archetype;
    private final World world;
    private IntBag pool = new IntBag();
    private int poolIndex;

    EntityPoolFactory(World world) {
        this.world = world;
        this.archetype = new ArchetypeBuilder().build(world);
    }

    void configureWith(int count) {
        this.poolIndex = 0;
        this.pool.setSize(0);
        this.pool.ensureCapacity(count);
        for (int i = 0; i < count; ++i) {
            this.pool.add(this.world.create(this.archetype));
        }
        Arrays.sort(this.pool.getData(), 0, this.pool.size());
    }

    Entity createEntity() {
        return this.world.getEntity(this.pool.getData()[this.poolIndex++]);
    }
}

