/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.io;

import com.artemis.Component;
import com.artemis.Entity;
import com.artemis.utils.Bag;
import com.artemis.utils.IntBag;
import com.artemis.utils.reflect.Field;
import com.artemis.utils.reflect.ReflectionException;

class EntityReference {
    public final Class<?> componentType;
    public final Field field;
    public final FieldType fieldType;
    public final transient Bag<Component> operations = new Bag();

    EntityReference(Class<?> componentType, Field field) {
        this.componentType = componentType;
        this.field = field;
        this.fieldType = FieldType.resolve(field);
    }

    void translate(Bag<Entity> translatedIds) {
        for (Component c : this.operations) {
            this.fieldType.translate(c, this.field, translatedIds);
        }
        this.operations.clear();
    }

    public String toString() {
        return "EntityReference{" + this.componentType.getSimpleName() + "." + this.field.getName() + " (" + (Object)((Object)this.fieldType) + "), operations=" + this.operations.size() + '}';
    }

    static enum FieldType {
        INT{

            @Override
            void translate(Component c, Field field, Bag<Entity> translatedIds) {
                try {
                    int oldId = (Integer)field.get((Object)c);
                    if (oldId != -1) {
                        field.set((Object)c, (Object)((Entity)translatedIds.get(oldId)).getId());
                    }
                }
                catch (ReflectionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ,
        INT_BAG{

            @Override
            void translate(Component c, Field field, Bag<Entity> translatedIds) {
                try {
                    IntBag bag = (IntBag)field.get((Object)c);
                    int s = bag.size();
                    for (int i = 0; s > i; ++i) {
                        int oldId = bag.get(i);
                        bag.set(i, ((Entity)translatedIds.get(oldId)).getId());
                    }
                }
                catch (ReflectionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ,
        ENTITY{

            @Override
            void translate(Component c, Field field, Bag<Entity> translatedIds) {
                try {
                    Entity e = (Entity)field.get((Object)c);
                    if (e != null) {
                        int oldId = e.getId();
                        field.set((Object)c, translatedIds.get(oldId));
                    }
                }
                catch (ReflectionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ,
        ENTITY_BAG{

            @Override
            void translate(Component c, Field field, Bag<Entity> translatedIds) {
                try {
                    Bag bag = (Bag)field.get((Object)c);
                    int s = bag.size();
                    for (int i = 0; s > i; ++i) {
                        Object o = bag.get(i);
                        if (!(o instanceof Entity)) {
                            return;
                        }
                        bag.set(i, translatedIds.get(((Entity)o).getId()));
                    }
                }
                catch (ReflectionException e) {
                    throw new RuntimeException(e);
                }
            }
        };


        abstract void translate(Component var1, Field var2, Bag<Entity> var3);

        static FieldType resolve(Field f) {
            Class type = f.getType();
            if (Integer.TYPE == type) {
                return INT;
            }
            if (Entity.class == type) {
                return ENTITY;
            }
            if (IntBag.class == type) {
                return INT_BAG;
            }
            if (Bag.class == type) {
                return ENTITY_BAG;
            }
            throw new RuntimeException("missing case: " + type.getSimpleName());
        }
    }
}

