/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.io;

import com.artemis.Component;
import com.artemis.Entity;
import com.artemis.EntitySubscription;
import com.artemis.annotations.Transient;
import com.artemis.io.ArchetypeMapper;
import com.artemis.io.SerializationException;
import com.artemis.io.SerializationKeyTracker;
import com.artemis.utils.IntBag;
import com.artemis.utils.reflect.ClassReflection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SaveFileFormat {
    public Metadata metadata;
    public ComponentIdentifiers componentIdentifiers;
    public IntBag entities;
    public ArchetypeMapper archetypes;
    transient SerializationKeyTracker tracker = new SerializationKeyTracker();

    public SaveFileFormat(IntBag entities) {
        this.entities = entities != null ? entities : new IntBag();
        this.componentIdentifiers = new ComponentIdentifiers();
        this.metadata = new Metadata();
        this.metadata.version = 1;
    }

    public SaveFileFormat(EntitySubscription es) {
        this(es.getEntities());
    }

    public SaveFileFormat() {
        this((IntBag)null);
    }

    public final Entity get(String key) {
        return this.tracker.get(key);
    }

    public final boolean has(String key) {
        return this.tracker.get(key) != null;
    }

    public final Set<String> keys() {
        return this.tracker.keys();
    }

    public static class ComponentIdentifiers {
        public Map<Class<? extends Component>, String> typeToName = new IdentityHashMap<Class<? extends Component>, String>();
        private Map<String, Class<? extends Component>> nameToType = new HashMap<String, Class<? extends Component>>();
        public Map<Class<? extends Component>, Integer> typeToId = new HashMap<Class<? extends Component>, Integer>();
        public Map<Integer, Class<? extends Component>> idToType = new HashMap<Integer, Class<? extends Component>>();
        transient Set<Class<? extends Component>> transientComponents = new HashSet<Class<? extends Component>>();

        void build() {
            if (this.typeToName.size() > 0) {
                this.buildFromNames();
            } else {
                this.buildFromIndices();
            }
        }

        public Class<? extends Component> getType(String name) {
            Class<? extends Component> type = this.nameToType.get(name);
            if (type == null) {
                throw new SerializationException("No component type with name: " + name);
            }
            return type;
        }

        public Collection<Class<? extends Component>> getTypes() {
            return this.nameToType.values();
        }

        private void buildFromNames() {
            Iterator<Map.Entry<Class<? extends Component>, String>> it = this.typeToName.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Class<? extends Component>, String> entry = it.next();
                Class<? extends Component> c = entry.getKey();
                if (ClassReflection.getDeclaredAnnotation(c, Transient.class) == null) {
                    this.nameToType.put(entry.getValue(), c);
                    if (this.typeToId.get(c) != null) continue;
                    this.typeToId.put(c, this.nameToType.size());
                    this.idToType.put(this.nameToType.size(), c);
                    continue;
                }
                this.transientComponents.add(c);
                it.remove();
            }
        }

        private void buildFromIndices() {
            Iterator<Map.Entry<Integer, Class<? extends Component>>> it = this.idToType.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Class<? extends Component>> entry = it.next();
                Class<? extends Component> c = entry.getValue();
                if (ClassReflection.getDeclaredAnnotation(c, Transient.class) == null) {
                    this.typeToId.put(c, this.nameToType.size());
                    continue;
                }
                this.transientComponents.add(c);
                it.remove();
            }
        }

        boolean isTransient(Class<? extends Component> c) {
            return this.transientComponents.contains(c);
        }
    }

    public static class Metadata {
        public static final int VERSION_1 = 1;
        public static final int LATEST = 1;
        public int version;
    }
}

